package com.atlassian.confluence.plugins.createcontent.template;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import org.apache.commons.lang3.StringUtils;

import static com.atlassian.confluence.plugins.createcontent.BlueprintConstants.BLUEPRINT_PARAM_KEY;

public class BlueprintsDisabledPredicate implements ModuleDescriptorPredicate {
    private final PluginAccessor pluginAccessor;

    public BlueprintsDisabledPredicate(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public boolean matches(ModuleDescriptor moduleDescriptor) {
        // Ignore non-web-items
        if (!(moduleDescriptor instanceof WebItemModuleDescriptor))
            return false;

        // Ignore non-blueprint web-items
        String webItemBlueprintKey = (String) (moduleDescriptor.getParams().get(BLUEPRINT_PARAM_KEY));
        boolean webItemHasBlueprint = StringUtils.isNotBlank(webItemBlueprintKey);
        if (!webItemHasBlueprint)
            return false;

        // Ignore items in disabled plugins
        if (!pluginAccessor.isPluginEnabled(moduleDescriptor.getPluginKey()))
            return false;

        // Ignore enabled blueprint web-items
        return !pluginAccessor.isPluginModuleEnabled(moduleDescriptor.getCompleteKey());
    }
}
