package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.services.PromotedBlueprintService;
import com.atlassian.confluence.plugins.createcontent.services.PromotedTemplateService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import java.util.Collection;

@Path("/promotion")
public class PromotedEntityResource extends AbstractRestResource {
    public static final String PARAM_BLUEPRINT_ID = "blueprintId";
    public static final String PARAM_SPACE_KEY = "spaceKey";
    public static final String PARAM_ID = "id";

    private final PromotedBlueprintService promotedBlueprintService;
    private final PromotedTemplateService promotedTemplateService;

    public PromotedEntityResource(
            final PromotedBlueprintService promotedBlueprintService,
            final PromotedTemplateService promotedTemplateService,
            final @ComponentImport PermissionManager permissionManager,
            final @ComponentImport SpaceManager spaceManager,
            final @ComponentImport AccessModeService accessModeService) {
        super(permissionManager, spaceManager, accessModeService);

        this.promotedBlueprintService = promotedBlueprintService;
        this.promotedTemplateService = promotedTemplateService;
    }

    @Path("promote-blueprint/{" + PARAM_BLUEPRINT_ID + "}")
    @PUT
    public boolean promoteBlueprint(@PathParam(PARAM_BLUEPRINT_ID) final String blueprintId,
                                    @QueryParam(PARAM_SPACE_KEY) String spaceKey) throws BlueprintIllegalArgumentException {
        return promotedBlueprintService.promoteBlueprint(blueprintId, spaceKey);
    }

    @Path("promote-blueprint/{" + PARAM_BLUEPRINT_ID + "}")
    @DELETE
    public boolean demoteBlueprint(@PathParam(PARAM_BLUEPRINT_ID) String blueprintId,
                                   @QueryParam(PARAM_SPACE_KEY) String spaceKey)
            throws BlueprintIllegalArgumentException {
        return promotedBlueprintService.demoteBlueprint(blueprintId, spaceKey);
    }

    @Path("promote-template/{" + PARAM_ID + "}")
    @PUT
    public void promoteTemplate(@PathParam(PARAM_ID) final long templateId, @QueryParam(PARAM_SPACE_KEY) String spaceKey)
            throws BlueprintIllegalArgumentException {
        promotedTemplateService.promoteTemplate(templateId, spaceKey);
    }

    @Path("promote-template/{" + PARAM_ID + "}")
    @DELETE
    public void demoteTemplate(@PathParam(PARAM_ID) long templateId, @QueryParam(PARAM_SPACE_KEY) String spaceKey)
            throws BlueprintIllegalArgumentException {
        promotedTemplateService.demoteTemplate(templateId, spaceKey);
    }

    @Path("promote-template/")
    @GET
    public Collection<Long> getPromotedTemplates(@QueryParam(PARAM_SPACE_KEY) String spaceKey) {
        checkEmptyParameter(spaceKey, PARAM_SPACE_KEY);
        final Space space = getAndCheckSpace(spaceKey);

        return promotedTemplateService.getPromotedTemplates(space);
    }
}
