package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.confluence.labels.SpaceLabelManager;
import com.atlassian.confluence.plugins.createcontent.events.SpaceBlueprintCreateEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * Listens for a SpaceBlueprintCreateEvent, and adds category to the created space.
 */
@Component
public class SpaceBlueprintCreationListener {
    private final SpaceLabelManager spaceLabelManager;
    private final EventPublisher eventPublisher;

    @Autowired
    public SpaceBlueprintCreationListener(
            final @ComponentImport SpaceLabelManager spaceLabelManager,
            final @ComponentImport EventPublisher eventPublisher) {
        this.spaceLabelManager = spaceLabelManager;
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void onSpaceBlueprintCreateEvent(SpaceBlueprintCreateEvent event) {
        if (event.getSpaceBlueprint().getCategory() != null)
            spaceLabelManager.addLabel(event.getSpace(), event.getSpaceBlueprint().getCategory());
    }

    @PreDestroy
    public void destroy() {
        eventPublisher.unregister(this);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        eventPublisher.register(this);
    }
}
