package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateDialogWebItemEntity;
import com.atlassian.confluence.plugins.createcontent.services.BlueprintDiscoveryService;
import com.atlassian.confluence.plugins.featurediscovery.service.FeatureDiscoveryService;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Sets.newHashSet;

@Component
public class DefaultBlueprintDiscoveryService implements BlueprintDiscoveryService {
    private final FeatureDiscoveryService featureDiscoveryService;

    @Autowired
    public DefaultBlueprintDiscoveryService(final @ComponentImport FeatureDiscoveryService featureDiscoveryService) {
        this.featureDiscoveryService = featureDiscoveryService;
    }

    @Override
    public List<CreateDialogWebItemEntity> discoverRecentlyInstalled(List<CreateDialogWebItemEntity> pluginItems) {
        List<ModuleCompleteKey> blueprintsModuleCompleteKeys = getBlueprintModuleCompleteKeys(pluginItems);
        List<ModuleCompleteKey> recentBlueprintsModuleCompleteKeys = featureDiscoveryService.getNew(blueprintsModuleCompleteKeys);

        updateRecentBlueprintItems(pluginItems, recentBlueprintsModuleCompleteKeys);

        return pluginItems;
    }

    private List<ModuleCompleteKey> getBlueprintModuleCompleteKeys(List<CreateDialogWebItemEntity> pluginItems) {
        List<ModuleCompleteKey> blueprintKeys = newArrayList();

        for (CreateDialogWebItemEntity createDialogWebItemEntity : pluginItems) {
            String blueprintModuleCompleteKey = createDialogWebItemEntity.getItemModuleCompleteKey();
            if (StringUtils.isNotBlank(blueprintModuleCompleteKey))
                blueprintKeys.add(new ModuleCompleteKey(blueprintModuleCompleteKey));
        }

        return blueprintKeys;
    }

    private void updateRecentBlueprintItems(List<CreateDialogWebItemEntity> pluginItems,
                                            List<ModuleCompleteKey> newBlueprintModuleKeys) {
        final Set<ModuleCompleteKey> newBlueprintModuleKeySet = newHashSet(newBlueprintModuleKeys);
        for (CreateDialogWebItemEntity createDialogWebItemEntity : pluginItems) {
            String blueprintModuleCompleteKey = createDialogWebItemEntity.getItemModuleCompleteKey();
            // Ignore non-BP web items
            if (StringUtils.isBlank(blueprintModuleCompleteKey))
                continue;

            if (newBlueprintModuleKeySet.contains(new ModuleCompleteKey(blueprintModuleCompleteKey)))
                createDialogWebItemEntity.setNew(true);
        }
    }
}
