package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.confluence.api.model.content.template.ContentBlueprintId;
import com.atlassian.confluence.plugins.dialog.wizard.api.DialogWizard;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.List;
import java.util.UUID;

/**
 * A Content Blueprint (old "Page" Blueprint) that can be modified and persisted to the database.
 *
 * @since 1.6
 */
@XmlRootElement
public class ContentBlueprint extends PluginBackedBlueprint {

    // DB pagetemplates.templateid + module complete key
    private ContentTemplateRef indexPageTemplateRef;
    private String indexKey;
    private String createResult;
    private String howToUseTemplate;
    private String indexTitleI18nKey;
    private DialogWizard dialogWizard;
    private List<ContentTemplateRef> contentTemplates;
    private String spaceKey;
    private boolean indexDisabled;

    public ContentBlueprint() {
    }

    public ContentBlueprint(UUID id) {
        setId(id);
    }

    // HACK - to refactor the BlueprintDescriptor into the ContentBlueprint in small steps, we start by having this
    // class implement the interface so that instances can be passed wherever a descriptor is required.

    @Nonnull
    @XmlTransient
    public ContentTemplateRef getFirstContentTemplateRef() {
        // Can throw ArrayOutOfBoundException, but that should never happen!
        return contentTemplates.get(0);
    }

    /**
     * @return a list of ContentTemplateRef for this Blueprint. If indexDisabled is true, this is not guaranteed to
     * return an empty list.
     */
    @Nonnull
    @XmlElement
    public List<ContentTemplateRef> getContentTemplateRefs() {
        return contentTemplates;
    }

    @Nonnull
    @XmlElement
    public ContentTemplateRef getIndexPageTemplateRef() {
        return indexPageTemplateRef;
    }

    @Nonnull
    @XmlElement
    public String getIndexKey() {
        return indexKey;
    }

    @Nullable
    @XmlElement
    public String getCreateResult() {
        return createResult;
    }

    @Nullable
    @XmlElement
    public String getIndexTitleI18nKey() {
        return indexTitleI18nKey;
    }

    @Nullable
    @XmlElement
    public String getHowToUseTemplate() {
        return howToUseTemplate;
    }

    @Nullable
    @XmlElement
    public DialogWizard getDialogWizard() {
        return dialogWizard;
    }

    @XmlElement
    public boolean isIndexDisabled() {
        return indexDisabled;
    }

    public void setContentTemplateRefs(@Nonnull List<ContentTemplateRef> contentTemplates) {
        this.contentTemplates = contentTemplates;
    }

    public void setCreateResult(@Nullable String createResult) {
        this.createResult = createResult;
    }

    public void setDialogWizard(@Nullable DialogWizard dialogWizard) {
        this.dialogWizard = dialogWizard;
    }

    public void setHowToUseTemplate(@Nullable String howToUseTemplate) {
        this.howToUseTemplate = howToUseTemplate;
    }

    public void setIndexKey(@Nonnull String indexKey) {
        this.indexKey = indexKey;
    }

    public void setIndexPageTemplateRef(@Nonnull ContentTemplateRef indexPageTemplateRef) {
        this.indexPageTemplateRef = indexPageTemplateRef;
    }

    public void setIndexTitleI18nKey(@Nonnull String indexTitleI18nKey) {
        this.indexTitleI18nKey = indexTitleI18nKey;
    }

    public void setIndexDisabled(@Nonnull boolean indexDisabled) {
        this.indexDisabled = indexDisabled;
    }

    @Nullable
    public String getSpaceKey() {
        return spaceKey;
    }

    public void setSpaceKey(@Nullable String spaceKey) {
        this.spaceKey = spaceKey != null && spaceKey.isEmpty() ? null : spaceKey;
    }

    @XmlTransient
    public ContentBlueprintId getContentBlueprintId() {
        return ContentBlueprintId.fromKeyAndSpaceString(getModuleCompleteKey(), spaceKey);
    }

    @Override
    public String toString() {
        return "KEY:" + getModuleCompleteKey() + "/SPACE:" + getSpaceKey() + "/CLONE:" + isPluginClone() + "/ID:" + getId();
    }
}
