package com.atlassian.confluence.plugins.createcontent.extensions;

import com.atlassian.confluence.spaces.Space;

import java.util.Map;

/**
 * Defines a handler that takes care of some aspect of Space creation via a Space Blueprint.
 * <p>
 * Handlers are called before and after the Space has been saved to the database.
 */
public interface SpaceCreationStep {
    boolean prehandle(Map<String, Object> context);

    void posthandle(Space space, Map<String, Object> context);
}
