package com.atlassian.confluence.plugins.createcontent.exceptions;

import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ResourceErrorBean {
    @XmlAttribute
    private int errorCode;
    @XmlAttribute
    private ResourceErrorType errorType;
    @XmlElement
    private Object errorData;
    @XmlElement
    private String errorMessage;

    // JAXB
    private ResourceErrorBean() {
    }

    public ResourceErrorBean(final int errorCode, @Nonnull final ResourceErrorType errorType, @Nullable final Object errorData, @Nonnull final String errorMessage) {
        this.errorCode = errorCode;
        this.errorType = errorType;
        this.errorData = errorData;
        this.errorMessage = errorMessage;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public ResourceErrorType getErrorType() {
        return errorType;
    }

    public Object getErrorData() {
        return errorData;
    }

    public String getErrorMessage() {
        return errorMessage;
    }
}
