/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.model;

import com.atlassian.cache.ManagedCache;
import com.atlassian.confluence.cache.CacheStatistics;
import javax.xml.bind.annotation.XmlElement;

public class CacheStatisticsEntity {
    private final CacheStatistics stats;
    private final ManagedCache managedCache;
    private final boolean clustered;

    public CacheStatisticsEntity(CacheStatistics stats, ManagedCache managedCache, boolean clustered) {
        this.stats = stats;
        this.managedCache = managedCache;
        this.clustered = clustered;
    }

    @XmlElement
    public String getType() {
        if (this.clustered && this.managedCache != null) {
            return this.managedCache.isLocal() ? "local" : "distributed";
        }
        return null;
    }

    @XmlElement
    public boolean getFlushable() {
        return this.managedCache != null && this.managedCache.isFlushable();
    }

    @XmlElement
    public long getHitCount() {
        return this.stats.getHitCount();
    }

    @XmlElement
    public String getNiceName() {
        return this.stats.getNiceName();
    }

    @XmlElement
    public long getMaxSize() {
        return this.stats.getMaxSize();
    }

    @XmlElement
    public String getName() {
        return this.stats.getName();
    }

    @XmlElement
    public long getSizeInBytes() {
        return this.stats.getSizeInBytes();
    }

    @XmlElement
    public Long getMissCount() {
        return CacheStatisticsEntity.nullIfNegative(this.stats.getMissCount());
    }

    @XmlElement
    public String getFormattedSizeInMegabytes() {
        return this.stats.getFormattedSizeInMegabytes();
    }

    @XmlElement
    public long getAccessCount() {
        return this.stats.getAccessCount();
    }

    @XmlElement
    public Long getHitPercent() {
        return CacheStatisticsEntity.nullIfNegative(this.stats.getHitPercent());
    }

    private static Long nullIfNegative(long value) {
        return value < 0L ? null : Long.valueOf(value);
    }

    @XmlElement
    public long getSize() {
        return this.stats.getSize();
    }

    @XmlElement
    public int getUsagePercent() {
        return this.stats.getUsagePercent();
    }

    @XmlElement
    public boolean hasContents() {
        return this.stats.hasContents();
    }

    @XmlElement
    public Long getExpiredCount() {
        return CacheStatisticsEntity.nullIfNegative(this.stats.getExpiredCount());
    }
}

