/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.model;

import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class HibernateQueryCacheEntity {
    private final List<Query> queries;

    public HibernateQueryCacheEntity(List<Query> queries) {
        this.queries = queries;
    }

    @JsonProperty
    public List<Query> getQueries() {
        return this.queries;
    }

    public static class Query {
        private final String sqlQueryString;
        private final int queryCount;
        private final int totalKeySize;

        public Query(String sqlQueryString, int queryCount, int totalKeySize) {
            this.sqlQueryString = sqlQueryString;
            this.queryCount = queryCount;
            this.totalKeySize = totalKeySize;
        }

        @JsonProperty
        public String getSqlQueryString() {
            return this.sqlQueryString;
        }

        @JsonProperty
        public int getQueryCount() {
            return this.queryCount;
        }

        @JsonProperty
        public int getTotalKeySizeBytes() {
            return this.totalKeySize;
        }

        @JsonProperty
        public int getAverageKeySizeBytes() {
            return this.totalKeySize / this.queryCount;
        }
    }
}

