define('confluence-browser-metrics/reporters/server-duration-reporter', [
    "internal/browser-metrics",
    "jquery"
], function (metrics, $) {

    var pendingReport = $.Deferred();

    $( function(){
        var metrics;
        try {
            metrics = JSON.parse($("#confluence-server-performance").html());
        } catch (e) {
            // SyntaxError
            metrics = null;
        }
        if (metrics !== null && metrics.serverDuration) {
            pendingReport.resolve(metrics);
        } else {
            pendingReport.resolve({});
        }
    });

    var serverDurationReporter = function (navigationEvent) {
        if (navigationEvent.isInitial) {
            return pendingReport.promise();
        } else {
            return {};
        }
    };

    return serverDurationReporter;

});