// We require spa-transitions here so that the click handler gets bound on the dashboard
require([
    "internal/browser-metrics",
    "confluence-browser-metrics/reporters/spa-transitions-reporter",
    "jquery",
    "confluence/api/event"
], function (
    metrics,
    spaTransitions,
    $,
    event
) {
    /**
     * Apdex start event is triggered quite early in first page loading.
     * So we want to start listening 'confluence.spa.navigation.performance' event, which is triggered from
     * confluence-frontend repo, as soon as possible
     */
    (function initSPANavigationMeasure() {
        var spaApdexEventKey = 'confluence.spa.navigation.performance'
        event.bind(spaApdexEventKey, function(e, params) {
            if (params.isStartEvent) {
                metrics.start({
                    key: spaApdexEventKey,
                    isInitial: false,
                    reporters:  function() {
                        return {
                            transitionTo: params.transitionTo
                        };
                    }
                });
            } else {
                metrics.end({
                    key: spaApdexEventKey,
                    isInitial: false
                });
            }
        });
    }());

    function measure() {
        // react dashboard fires all the events from the front end repo
        var isReactDashboard = $('#confluence-ui.confluence-dashboard').length;

        if (isReactDashboard) {
            return;
        }

        // both old and backbone dashboards use the 'dashboard' class on the body tag
        var dashboardIsPresent = $('body.dashboard').length;

        // backbone dashboard triggers when the first element is added to the content (if it's not a loading view)
        var readyElement = '.confluence-dashboard .list-container li:not(.loading-view)';

        var isOldDashboard = !$('.confluence-dashboard').length;

        if (isOldDashboard) {
            readyElement = '.dashboard';
        }

        if (dashboardIsPresent) {
            metrics.start({
                key: "confluence.dashboard.view",
                ready: readyElement,
                isInitial: true
            });
        }
    }

    $(measure);
});
