require(["internal/browser-metrics", "jquery"], function (metrics, $) {

    function measure() {
        var path = window.location.pathname.
                substring(AJS.Meta.get('context-path').length). // drop context path
                split(';', 1)[0]; // drop optional JSESSIONID;

        if (path === "/display/" + AJS.Meta.get('space-key') ||
            // Preparing for route migration that is happening.
            // The new route will be in place before SPA is completed rolled out.
            // In SPA it won't matter as we have new events being fired
            // and we don't load contexts
            path === "/spaces/" + AJS.Meta.get('space-key')) {
            metrics.start({
                key: "confluence.space.view",
                ready: ".space",
                isInitial: true
            });
        }
    }

    $(measure);
});