/* global console:true, AJS:true, Math: true */

(function() {
    var BrowserMetrics = window.BrowserMetrics || {};

    BrowserMetrics.isFunction = function(object) {
        return !!(object && object.constructor && object.call && object.apply);
    };

    BrowserMetrics.isEnabled = function() {
        if (BrowserMetrics.enabled === undefined) {
            BrowserMetrics.enabled = true;
        }
        return BrowserMetrics.enabled;
    };
    window.BrowserMetrics = BrowserMetrics;
}());

(function () {
    var BrowserMetrics = window.BrowserMetrics || {};

    if (BrowserMetrics.isEnabled()) {
        var VERSION = 5;

        var THRESHOLD = 12000; // Timings above this threshold will be clipped to an 'x' value.

        var round = function(value) {
            return Math.round(value);
        };

        var round2 = function(value) {
            return Math.round(value * 100) / 100;
        };

        var initPageLoad = function(global) {
            // Parses url into scheme / host / path
            var parseUrl = (function () {
                var ABSOLUTE_PATTERN = /^(\w+):\/\/([^\/]*)(.*)$/;
                return function (url) {
                    var match = url.match(ABSOLUTE_PATTERN);
                    if (!match) {
                        return {
                            path: url
                        };
                    }
                    return {
                        scheme: match[1],
                        host: match[2],
                        path: match[3]
                    };
                };
            }());

            // Logs window.performance.timing events
            var logPerformanceTimingEvents = (function () {
                // Firefox performance object doesn't have enumerable properties, so hardcode
                var TIMING_KEYS = [
                    "secureConnectionStart",
                    "requestStart",
                    "responseStart",
                    "responseEnd",
                    "domContentLoadedEventStart",
                    "domContentLoadedEventEnd",
                    "loadEventEnd"
                ];
                return function (cb) {
                    if (global.performance) {
                        var timing = global.performance.timing;
                        var navigationStart = timing.navigationStart;
                        if (navigationStart) {
                            for (var i = 0; i < TIMING_KEYS.length; ++i) {
                                var eventName = TIMING_KEYS[i];
                                var val = timing[eventName];
                                // This means that there is not event;
                                // Atlassian analytics drop events containing null, so don't add them.
                                if (val) {
                                    cb(eventName, val - navigationStart);
                                }
                            }
                        }
                    }
                };
            }());

            var getPage = (function () {
                var PATTERNS = [
                    // JIRA
                    { key: "LOGIN", pattern: /^\/login.*/i },
                    { key: "J-DASH", pattern: /^\/secure\/dashboard\.jspa.*/i },
                    { key: "J-ISSUE", pattern: /^\/browse\/\w+\-\w+.*/i },
                    { key: "J-NAV", pattern: /^\/issues.*/i },
                    { key: "J-RAPID", pattern: /secure\/rapidboard\.jspa/i },
                    // Service Desk
                    // <contextpath>/servicedesk/agent/.*
                    { key: "SD-AGENT", pattern: /^(\/\w+)?\/servicedesk\/agent\/.*/i },
                    // <contextpath>/servicedesk/customer/.*
                    { key: "SD-CUSTOMER", pattern: /^(\/\w+)?\/servicedesk\/customer\/.*/i },
                    // Confluence
                    { key: "C-DASH", pattern: /^\/wiki(\/)?(\?.*|#.*)?$/i },
                    { key: "C-DASH", pattern: /^\/wiki\/dashboard\.action.*$/i },
                    { key: "C-SPACE", pattern: /^\/wiki\/display\/\w+(\?.*|#.*)?$/i },
                    { key: "C-PAGE", pattern: /^\/wiki\/display\/\w+\/.*/i },
                    { key: "C-PAGE", pattern: /^\/wiki\/pages\/viewpage\.action.*/i },
                    { key: "C-BLOG", pattern: /^\/wiki\/display\/~\w+\/\d+\/\d+\/\d+\/.*/i },
                    { key: "C-EDITOR", pattern: /^\/wiki\/pages\/editpage\.action.*/i },
                    { key: "C-CREATE", pattern: /^\/wiki\/pages\/createpage\.action.*/i }
                ];


                return function getPage() {
                    var path = parseUrl(global.location.href).path;
                    for (var i = 0; i < PATTERNS.length; ++i) {
                        var pattern = PATTERNS[i];
                        if (path.match(pattern.pattern)) {
                            return pattern.key;
                        }
                    }
                    return null;
                };
            }());

            function doRecordPerformance() {
                var page = getPage();
                if (page) {
                    logPerformanceTimingEvents(function (key, value) {
                        var name = 'browser.metrics.' + key,
                            data = {
                                version: VERSION,
                                page: page,
                                value: value > THRESHOLD ? 'x' : Math.ceil((value) / 100),
                                rawValue: round(value)
                            };
                        AJS.Analytics ? AJS.Analytics.triggerPrivacyPolicySafeEvent(name, data) : AJS.trigger('analyticsEvent', { name: name, data: data });
                    });
                }
            }

            function recordPerformance() {
                try {
                    doRecordPerformance();
                }
                catch (e) {
                    if (window.console) {
                        window.console.log("Error reporting browser metrics: " + e);
                    }
                }
            }

            // Polls for the end of the performance load event
            function checkPerformanceLoadEventEnd() {
                if (global.performance.timing.loadEventEnd) {
                    recordPerformance();
                }
                else {
                    setTimeout(checkPerformanceLoadEventEnd, 1000);
                }
            }

            if (global.performance && global.performance.timing) {
                checkPerformanceLoadEventEnd();
            }
        };

        if (!window.ATL_PERF) {
            window.ATL_PERF = {};
        }
        window.ATL_PERF.initPageLoad = initPageLoad;
    }
}());
