/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.auditing.utils;

import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserKey;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChangedValuesCalculator<T> {
    private static final int MAX_STRING_LENGTH = 250;
    private static final String CHANGED_VALUE_PREFIX = "audit.logging.changed.value.";
    private final I18nResolver i18nResolver;
    private final LocaleResolver localeResolver;
    private final T oldObject;
    private final T newObject;

    public ChangedValuesCalculator(@Nonnull I18nResolver i18nResolver, @Nonnull LocaleResolver localeResolver, @Nullable T oldObject, @Nullable T newObject) {
        this.i18nResolver = i18nResolver;
        this.localeResolver = localeResolver;
        this.oldObject = oldObject;
        this.newObject = newObject;
    }

    public Optional<ChangedValue> getDifference(String key, Function<T, Object> function) {
        Object oldValue;
        if (this.oldObject != null && this.newObject != null) {
            Object newValue;
            Object oldValue2 = function.apply(this.oldObject);
            if (!Objects.equals(oldValue2, newValue = function.apply(this.newObject))) {
                return Optional.of(new ChangedValue(this.translate(key), this.convertToString(oldValue2), this.convertToString(newValue)));
            }
        } else if (this.newObject != null) {
            Object newValue = function.apply(this.newObject);
            if (newValue != null) {
                return Optional.of(new ChangedValue(this.translate(key), this.convertToString(newValue)));
            }
        } else if (this.oldObject != null && (oldValue = function.apply(this.oldObject)) != null) {
            return Optional.of(new ChangedValue(this.translate(key), this.convertToString(oldValue), null));
        }
        return Optional.empty();
    }

    private String translate(String key) {
        return this.i18nResolver.getText(this.localeResolver.getLocale((UserKey)null), CHANGED_VALUE_PREFIX + key);
    }

    private String convertToString(Object obj) {
        String stringRepresentation = Objects.toString(obj, "");
        if (stringRepresentation.length() > 250) {
            stringRepresentation = stringRepresentation.substring(0, 250) + "...";
        }
        return stringRepresentation;
    }
}

