/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.auditing.listeners;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserKey;
import java.util.Locale;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractEventListener
implements InitializingBean,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AuditService auditService;
    private final EventListenerRegistrar eventListenerRegistrar;
    private final I18nResolver i18nResolver;
    private final LocaleResolver localeResolver;

    protected AbstractEventListener(AuditService auditService, EventListenerRegistrar eventListenerRegistrar, I18nResolver i18nResolver, LocaleResolver localeResolver) {
        this.auditService = auditService;
        this.eventListenerRegistrar = eventListenerRegistrar;
        this.i18nResolver = i18nResolver;
        this.localeResolver = localeResolver;
    }

    protected void saveToBroker(Supplier<AuditEvent> entitySupplier) {
        try {
            this.auditService.audit(entitySupplier.get());
        }
        catch (Exception e) {
            this.getLogger().debug("Error handling entity", (Throwable)e);
        }
    }

    String translate(String messageKey) {
        return this.i18nResolver.getText(this.localeResolver.getLocale((UserKey)null), messageKey);
    }

    String translateIntoEnglish(String messageKey) {
        return this.i18nResolver.getRawText(Locale.ENGLISH, messageKey);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventListenerRegistrar.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    protected Logger getLogger() {
        return this.log;
    }
}

