(function ($) {

    /**
     * Set label of next button
     */
    function setSubmitButtonLabel(text) {
        $('.create-dialog-create-button:visible').text(text);
    }

    function selectItem($item) {
        AJS.trigger('selected.health-monitor-types', $item);
        
        $item.addClass('selected').siblings().removeClass('selected');
    }

    // Select report type dialog
    function initSelectMonitorTypeDialog(e, state) {
        AJS.trigger('analyticsEvent', {name: 'confluence-spaces.playbook.health-monitor.clicked'});

        var $selectionContainer = $('#health-monitor-types');
        var $templates = $selectionContainer.find('.template');
        $templates.first().addClass('selected');
        $templates
            .click(function() {
                selectItem($(this));

                var descriptionElement = $('.dialog-wizard-page-description').children().last();
                var description = "";
                switch ($(this).attr('id')) {
                    case "project-health-monitor":
                        description = AJS.I18n.getText("health.monitor.blueprint.wizard.description.content.project");
                        break;
                    case "leadership-health-monitor":
                        description = AJS.I18n.getText("health.monitor.blueprint.wizard.description.content.leadership");
                        break;
                    case "service-health-monitor":
                        description = AJS.I18n.getText("health.monitor.blueprint.wizard.description.content.service");
                }

                descriptionElement.text(description);
            })
            .dblclick(function() {
                $('.create-dialog-create-button:visible').click();
            });
        $selectionContainer
            .attr('tabindex', 0)
            .keydown(function(event) {
                if (event.keyCode == 38 || event.keyCode == 40) { // up or down
                    event.preventDefault(); // prevents page behind the dialog from scrolling in FF

                    var $selected = $selectionContainer.find('.selected'),
                        $newSelected;
                    if (event.keyCode == 38) // up
                        $newSelected = $selected.prev().length ? $selected.prev() : $templates.last();
                    else if (event.keyCode == 40) // down
                        $newSelected = $selected.next().length ? $selected.next() : $templates.first();
                    selectItem($newSelected);
                }
            });

        // set default submit button label
        setSubmitButtonLabel('Next');
    }

    function submitSelectMonitorTypeDialog(e, state) {
        var selectedTypeId = state.$container.find('.selected').attr('id');
        switch (selectedTypeId) {
            case "project-health-monitor":
                state.nextPageId = 'projectMonitorWizard-form';
                break;
            case "leadership-health-monitor":
                state.nextPageId = 'leadershipMonitorWizard-form';
                break;
            case "service-health-monitor":
                state.nextPageId = 'serviceMonitorWizard-form';
                break;
            default:
                return false;
        }
    }

    function onCadenceSelect() {
        if ($(this).find(":selected").text() == "Other") {
            $("#other-cadence-input").css({'display' : 'inline'});
        } else {
            $("#other-cadence-input").css({'display' : 'none'});
        }
    }

    function setContentTemplate(state, templateKey) {
        state.pageData.contentTemplateKey = templateKey;
    }

    function convertToUserKeys($container, pageData, templatePrefix, dataKey) {
        var usersList = $container.find('#' + templatePrefix + '-' + dataKey).select2('data');
        var usersByUserKey = usersList.map(function(user) {
            return user.userKey;
        }).join(',');

        pageData[dataKey] = usersByUserKey;
    }

    function initProjectMonitorFormDialog(e, state) {
        AJS.trigger('analyticsEvent', {name: 'confluence-spaces.playbook.project-monitor.clicked'});

        $("#monitor-cadence").on('change', onCadenceSelect);
    }

    function submitProjectMonitorFormDialog(e, state) {
        convertToUserKeys(state.$container, state.pageData, 'project', 'sponsor');
        convertToUserKeys(state.$container, state.pageData, 'project', 'owner');
        setContentTemplate(state, 'projectmonitor-template');
    }

    function initLeadershipMonitorFormDialog(e, state) {
        AJS.trigger('analyticsEvent', {name: 'confluence-spaces.playbook.leadership-monitor.clicked'});

        $("#monitor-cadence").on('change', onCadenceSelect);
    }

    function submitLeadershipMonitorFormDialog(e, state) {
        convertToUserKeys(state.$container, state.pageData, 'leadership', 'sponsor');
        setContentTemplate(state, 'leadershipmonitor-template');
    }

    function initServiceMonitorFormDialog(e, state) {
        AJS.trigger('analyticsEvent', {name: 'confluence-spaces.playbook.service-monitor.clicked'});

        $("#monitor-cadence").on('change', onCadenceSelect);
    }

    function submitServiceMonitorFormDialog(e, state) {
        setContentTemplate(state, 'servicemonitor-template');
    }

    Confluence.Blueprint.setWizard('com.atlassian.confluence.plugins.atlassian-playbook-blueprints:healthmonitor-blueprint-item', function(wizard) {
        wizard.on("post-render.healthMonitorWizard-start", initSelectMonitorTypeDialog);
        wizard.on("submit.healthMonitorWizard-start", submitSelectMonitorTypeDialog);

        wizard.on("post-render.projectMonitorWizard-form", initProjectMonitorFormDialog);
        wizard.on("submit.projectMonitorWizard-form", submitProjectMonitorFormDialog);

        wizard.on("post-render.leadershipMonitorWizard-form", initLeadershipMonitorFormDialog);
        wizard.on("submit.leadershipMonitorWizard-form", submitLeadershipMonitorFormDialog);

        wizard.on("post-render.serviceMonitorWizard-form", initServiceMonitorFormDialog);
        wizard.on("submit.serviceMonitorWizard-form", submitServiceMonitorFormDialog);
    });
})(AJS.$);