/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.analytics.jobs;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.confluence.plugins.analytics.jobs.AnalyticsConfigServiceWrapper;
import com.atlassian.confluence.plugins.analytics.jobs.PeriodicEventSupplierModuleDescriptor;
import com.atlassian.confluence.plugins.analytics.jobs.api.PeriodicEvent;
import com.atlassian.confluence.plugins.analytics.jobs.api.PeriodicEventSupplier;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="periodicEventPublisherJob")
public class PeriodicEventPublisherJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(PeriodicEventPublisherJob.class);
    private final EventPublisher eventPublisher;
    private final BundleContext bundleContext;
    private final PluginModuleTracker<PeriodicEventSupplier, PeriodicEventSupplierModuleDescriptor> eventFactoryTracker;

    @Autowired
    PeriodicEventPublisherJob(@ComponentImport EventPublisher eventPublisher, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginEventManager pluginEventManager, BundleContext bundleContext) {
        this.eventPublisher = eventPublisher;
        this.bundleContext = bundleContext;
        this.eventFactoryTracker = DefaultPluginModuleTracker.create((PluginAccessor)pluginAccessor, (PluginEventManager)pluginEventManager, PeriodicEventSupplierModuleDescriptor.class);
    }

    public @Nullable JobRunnerResponse runJob(JobRunnerRequest request) {
        try (AnalyticsConfigServiceWrapper analyticsConfigServiceWrapper = new AnalyticsConfigServiceWrapper(this.bundleContext);){
            boolean canCollectAnalytics = analyticsConfigServiceWrapper.getAnalyticsConfigService().map(AnalyticsConfigService::canCollectAnalytics).orElse(false);
            if (!canCollectAnalytics) {
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.aborted((String)"Can't collect analytics.");
                return jobRunnerResponse;
            }
        }
        int timeout = Integer.parseInt(System.getProperty("confluence.periodic.task.timeout", "5000"));
        this.eventFactoryTracker.getModules().forEach(eventSupplier -> {
            Future<PeriodicEvent> future = Executors.newSingleThreadExecutor().submit(eventSupplier);
            try {
                PeriodicEvent periodicEvent = future.get(timeout, TimeUnit.MILLISECONDS);
                this.eventPublisher.publish((Object)periodicEvent);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                future.cancel(true);
                log.error("{} was taking too long to supply the event. Cancelling.", (Object)eventSupplier.getClass().getName());
            }
        });
        return JobRunnerResponse.success();
    }
}

