/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest.module.xmlrpc.mail;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.jmx.JmxSMTPMailServer;
import com.atlassian.confluence.plugin.functest.module.xmlrpc.mail.MailServerHelperService;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.user.User;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailServerHelperServiceDelegate
implements MailServerHelperService {
    private PermissionManager permissionManager;
    private BandanaManager bandanaManager;

    public MailServerManager getMailServerManager() {
        return MailFactory.getServerManager();
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public BandanaManager getBandanaManager() {
        return this.bandanaManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    private boolean isCurrentUserAnAdmin() {
        User user = AuthenticatedUserThreadLocal.getUser();
        return null != user && this.getPermissionManager().hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    private SMTPMailServer toSMTPMailServer(Map mailServerStructure) throws RemoteException {
        JmxSMTPMailServer smtpMailServer = new JmxSMTPMailServer(new Long((String)mailServerStructure.get("id")), (String)mailServerStructure.get("name"), null, (String)mailServerStructure.get("fromAddress"), (String)mailServerStructure.get("prefix"), StringUtils.isNotBlank((String)((String)mailServerStructure.get("jndiLocation"))), (String)mailServerStructure.get("jndiLocation"), (String)mailServerStructure.get("userName"), (String)mailServerStructure.get("password"));
        String[] smtpServerAddressParts = StringUtils.split((String)((String)mailServerStructure.get("address")), (char)':');
        if (smtpServerAddressParts.length == 1) {
            smtpMailServer.setHostname(smtpServerAddressParts[0]);
            smtpMailServer.setSmtpPort("25");
        } else if (smtpServerAddressParts.length == 2) {
            smtpMailServer.setHostname(smtpServerAddressParts[0]);
            smtpMailServer.setSmtpPort(smtpServerAddressParts[1]);
        } else {
            throw new RemoteException("Invalid address specified: " + mailServerStructure.get("address"));
        }
        return smtpMailServer;
    }

    private Hashtable<String, String> toHashtable(SMTPMailServer smtpMailServer) throws RemoteException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (null != smtpMailServer.getId()) {
            hashtable.put("id", String.valueOf(smtpMailServer.getId()));
        }
        if (null != smtpMailServer.getName()) {
            hashtable.put("name", smtpMailServer.getName());
        }
        if (null != smtpMailServer.getDefaultFrom()) {
            hashtable.put("fromAddress", smtpMailServer.getDefaultFrom());
        }
        if (null != smtpMailServer.getPrefix()) {
            hashtable.put("prefix", smtpMailServer.getPrefix());
        }
        if (null != smtpMailServer.getJndiLocation()) {
            hashtable.put("jndiLocation", smtpMailServer.getJndiLocation());
        }
        if (null != smtpMailServer.getUsername()) {
            hashtable.put("userName", smtpMailServer.getUsername());
        }
        if (null != smtpMailServer.getPassword()) {
            hashtable.put("password", smtpMailServer.getPassword());
        }
        if (null != smtpMailServer.getHostname() && null != smtpMailServer.getSmtpPort()) {
            hashtable.put("address", smtpMailServer.getHostname() + ":" + smtpMailServer.getSmtpPort());
        }
        return hashtable;
    }

    private void validateMailServer(SMTPMailServer smtpMailServer) throws RemoteException {
        if (StringUtils.isBlank((String)smtpMailServer.getName())) {
            throw new RemoteException("Mail server name not specified.");
        }
        if (StringUtils.isBlank((String)smtpMailServer.getDefaultFrom())) {
            throw new RemoteException("From address not specified.");
        }
        if (StringUtils.isBlank((String)smtpMailServer.getPrefix())) {
            throw new RemoteException("Prefix not specified.");
        }
        if (StringUtils.isBlank((String)smtpMailServer.getHostname()) && StringUtils.isBlank((String)smtpMailServer.getJndiLocation())) {
            throw new RemoteException("Server address/JNDI location not specified.");
        }
    }

    private Map<Long, SMTPMailServer> getMailServersMap() {
        LinkedHashMap mailServersMap = (LinkedHashMap)this.getBandanaManager().getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "atlassian.confluence.smtp.mail.accounts");
        if (null == mailServersMap) {
            mailServersMap = new LinkedHashMap();
        }
        return mailServersMap;
    }

    private void persistMailServersMap(Map<Long, SMTPMailServer> mailServersMap) {
        this.getBandanaManager().setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "atlassian.confluence.smtp.mail.accounts", mailServersMap);
    }

    @Override
    public String createMailServer(String authToken, Hashtable mailServerStructure) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        SMTPMailServer smtpMailServer = this.toSMTPMailServer(mailServerStructure);
        this.validateMailServer(smtpMailServer);
        smtpMailServer.setId(Long.valueOf(System.currentTimeMillis()));
        Map<Long, SMTPMailServer> mailServersMap = this.getMailServersMap();
        mailServersMap.put(smtpMailServer.getId(), smtpMailServer);
        this.persistMailServersMap(mailServersMap);
        return smtpMailServer.getId().toString();
    }

    @Override
    public boolean updateMailServer(String authToken, Hashtable mailServerStructure) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        SMTPMailServer smtpMailServer = this.toSMTPMailServer(mailServerStructure);
        Long mailServerId = smtpMailServer.getId();
        Map<Long, SMTPMailServer> mailServersMap = this.getMailServersMap();
        mailServersMap.put(mailServerId, smtpMailServer);
        this.persistMailServersMap(mailServersMap);
        return true;
    }

    @Override
    public Hashtable<String, String> readMailServer(String authToken, String mailServerId) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        Long mailServerIdLong = new Long(mailServerId);
        Map<Long, SMTPMailServer> mailServersMap = this.getMailServersMap();
        SMTPMailServer smtpMailServer = mailServersMap.get(mailServerIdLong);
        return null != smtpMailServer ? this.toHashtable(smtpMailServer) : null;
    }

    @Override
    public boolean deleteMailServer(String authToken, String mailServerId) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        Long mailServerIdLong = new Long(mailServerId);
        Map<Long, SMTPMailServer> mailServersMap = this.getMailServersMap();
        mailServersMap.remove(mailServerIdLong);
        this.persistMailServersMap(mailServersMap);
        return true;
    }

    @Override
    public Hashtable<String, String> getMailServerIdsAndNames(String authToken) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        Map<Long, SMTPMailServer> mailServersMap = this.getMailServersMap();
        Hashtable<String, String> idsToNamesMap = new Hashtable<String, String>(mailServersMap.size());
        for (Map.Entry<Long, SMTPMailServer> e : mailServersMap.entrySet()) {
            idsToNamesMap.put(e.getKey().toString(), e.getValue().getName());
        }
        return idsToNamesMap;
    }

    public String login(String s, String s1) throws RemoteException {
        return null;
    }

    public boolean logout(String s) throws RemoteException {
        return false;
    }
}

