/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.SeleniumConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.TesterConfiguration;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ConfluencePluginSeleniumTestCaseBase
extends TestCase {
    protected SeleniumConfluenceWebTester tester;

    protected SeleniumConfluenceWebTester createConfluenceWebTester() {
        try {
            return new SeleniumConfluenceWebTester(new TesterConfiguration(), this.getSeleniumServerPort(), this.getBrowserStartCommand());
        }
        catch (IOException ioe) {
            Assert.fail((String)("Unable to create tester: " + ioe.getMessage()));
            return null;
        }
    }

    protected String getBrowserStartCommand() {
        return System.getProperty("com.atlassian.confluence.plugin.functest.selenium.browser");
    }

    protected int getSeleniumServerPort() {
        return Integer.getInteger("com.atlassian.confluence.plugin.functest.selenium.port", 4444);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tester = this.createConfluenceWebTester();
        this.tester.start();
        this.tester.login();
        this.tester.installTestLibrary();
        this.tester.installPlugin();
        this.tester.updateLicense();
        this.tester.restoreData();
        this.tester.open(this.tester.getContextPath() + "/admin/editgeneralconfig.action");
        this.tester.type("css=form[name='editgeneralconfig'] input[name='domainName']", this.tester.getBaseUrl());
        this.tester.submit("css=form[name='editgeneralconfig']");
        this.tester.waitForPageToLoad();
    }

    protected void tearDown() throws Exception {
        this.tester.logout();
        this.tester.stop();
        super.tearDown();
    }

    protected ConfluenceWebTester getTester() {
        return this.tester;
    }
}

