/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.JWebUnitConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.TesterConfiguration;
import com.atlassian.confluence.plugin.functest.helper.AttachmentHelper;
import com.atlassian.confluence.plugin.functest.helper.BandanaHelper;
import com.atlassian.confluence.plugin.functest.helper.BlogPostHelper;
import com.atlassian.confluence.plugin.functest.helper.CommentHelper;
import com.atlassian.confluence.plugin.functest.helper.GroupHelper;
import com.atlassian.confluence.plugin.functest.helper.HelperFactory;
import com.atlassian.confluence.plugin.functest.helper.IndexHelper;
import com.atlassian.confluence.plugin.functest.helper.MailServerHelper;
import com.atlassian.confluence.plugin.functest.helper.PageHelper;
import com.atlassian.confluence.plugin.functest.helper.SpaceHelper;
import com.atlassian.confluence.plugin.functest.helper.UserHelper;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import net.sourceforge.jwebunit.junit.WebTestCase;

public class AbstractConfluencePluginWebTestCase
extends WebTestCase {
    protected JWebUnitConfluenceWebTester createConfluenceWebTester() {
        try {
            return new JWebUnitConfluenceWebTester(new TesterConfiguration());
        }
        catch (IOException ioe) {
            Assert.fail((String)("Unable to create tester: " + ioe.getMessage()));
            return null;
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tester = this.createConfluenceWebTester();
        this.beginAt("/");
        this.loginAsAdmin();
        this.installTestLibrary();
        this.installPlugin();
        this.updateLicense();
        this.restoreData();
        this.updateBaseUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBaseUrl() {
        try {
            this.getConfluenceWebTester().gotoPageWithEscalatedPrivileges("/admin/editgeneralconfig.action");
            this.setWorkingForm("editgeneralconfig");
            this.setTextField("domainName", this.getConfluenceWebTester().getBaseUrl());
            this.submit("confirm");
        }
        finally {
            this.getConfluenceWebTester().dropEscalatedPrivileges();
        }
    }

    protected void tearDown() throws Exception {
        this.logout();
        super.tearDown();
    }

    protected ConfluenceWebTester getConfluenceWebTester() {
        return (ConfluenceWebTester)this.tester;
    }

    public void dropEscalatedPrivileges() {
        this.getConfluenceWebTester().dropEscalatedPrivileges();
    }

    public boolean gotoPageWithEscalatedPrivileges(String destination, String urlEncoding) {
        return this.getConfluenceWebTester().gotoPageWithEscalatedPrivileges(destination, urlEncoding);
    }

    public boolean gotoPageWithEscalatedPrivileges(String destination) {
        return this.getConfluenceWebTester().gotoPageWithEscalatedPrivileges(destination);
    }

    protected void login(String username, String password) {
        this.getConfluenceWebTester().login(username, password);
    }

    protected void login() {
        this.getConfluenceWebTester().login();
    }

    protected void loginAsAdmin() {
        this.getConfluenceWebTester().login(this.getConfluenceWebTester().getAdminUserName(), this.getConfluenceWebTester().getAdminPassword());
    }

    protected void logout() {
        this.getConfluenceWebTester().logout();
    }

    public void updateLicense() throws IOException {
        this.getConfluenceWebTester().updateLicense();
    }

    public void refreshLicense() {
        this.getConfluenceWebTester().refreshLicense();
    }

    public void installTestLibrary() {
        this.getConfluenceWebTester().installTestLibrary();
    }

    public void installPlugin() {
        this.getConfluenceWebTester().installPlugin();
    }

    public void restoreData() {
        this.getConfluenceWebTester().restoreData();
    }

    public void restoreData(File exportZip) {
        this.getConfluenceWebTester().restoreData(exportZip);
    }

    public void flushCaches() {
        this.getConfluenceWebTester().flushCaches();
    }

    public void reindex() {
        this.getIndexHelper().update();
    }

    public void assertResourceXsrfProtected(String resourcePath) {
        this.getConfluenceWebTester().assertResourceXsrfProtected(resourcePath);
    }

    public PageHelper getPageHelper(long pageId) {
        return HelperFactory.createPageHelper(this.getConfluenceWebTester(), pageId);
    }

    public PageHelper getPageHelper() {
        return HelperFactory.createPageHelper(this.getConfluenceWebTester());
    }

    public BlogPostHelper getBlogPostHelper(long blogPostId) {
        return HelperFactory.createBlogPostHelper(this.getConfluenceWebTester(), blogPostId);
    }

    public BlogPostHelper getBlogPostHelper() {
        return HelperFactory.createBlogPostHelper(this.getConfluenceWebTester());
    }

    public SpaceHelper getSpaceHelper(String spaceKey) {
        return HelperFactory.createSpaceHelper(this.getConfluenceWebTester(), spaceKey);
    }

    public SpaceHelper getSpaceHelper() {
        return HelperFactory.createSpaceHelper(this.getConfluenceWebTester());
    }

    public CommentHelper getCommentHelper(long commentId) {
        return HelperFactory.createCommentHelper(this.getConfluenceWebTester(), commentId);
    }

    public CommentHelper getCommentHelper() {
        return HelperFactory.createCommentHelper(this.getConfluenceWebTester());
    }

    public UserHelper getUserHelper(String userName) {
        return HelperFactory.createUserHelper(this.getConfluenceWebTester(), userName);
    }

    public UserHelper getUserHelper() {
        return HelperFactory.createUserHelper(this.getConfluenceWebTester());
    }

    public GroupHelper getGroupHelper(String groupName) {
        return HelperFactory.createGrouphelper(this.getConfluenceWebTester(), groupName);
    }

    public GroupHelper getGroupHelper() {
        return HelperFactory.createGrouphelper(this.getConfluenceWebTester());
    }

    public MailServerHelper getMailServerHelper(long id) {
        return HelperFactory.createMailServerHelper(this.getConfluenceWebTester(), id);
    }

    public MailServerHelper getMailServerHelper() {
        return HelperFactory.createMailServerHelper(this.getConfluenceWebTester());
    }

    public AttachmentHelper getAttachmentHelper() {
        return HelperFactory.createAttachmentHelper(this.getConfluenceWebTester());
    }

    public AttachmentHelper getAttachmentHelper(long id, String fileName) {
        return HelperFactory.createAttachmentHelper(this.getConfluenceWebTester(), id, fileName);
    }

    public BandanaHelper getBandanaHelper(String spaceKey, String bandanaKey) {
        return HelperFactory.createBandanaHelper(this.getConfluenceWebTester(), spaceKey, bandanaKey);
    }

    public BandanaHelper getBandanaHelper(String bandanaKey) {
        return HelperFactory.createBandanaHelper(this.getConfluenceWebTester(), "", bandanaKey);
    }

    public BandanaHelper getBandanaHelper() {
        return HelperFactory.createBandanaHelper(this.getConfluenceWebTester(), "");
    }

    public IndexHelper getIndexHelper() {
        return HelperFactory.createIndexHelper(this.getConfluenceWebTester());
    }
}

