package com.atlassian.confluence.plugin.functest.helper;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapService;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.RemoteComment;
import org.apache.commons.lang.StringUtils;

import javax.xml.rpc.ServiceException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;

public class CommentHelper extends ContentHelper
{

    private long parentId;

    private long contentId;

    private String lastModifier;

    private Date lastModifiedDate;

    public CommentHelper(final ConfluenceWebTester confluenceWebTester, final long id)
    {
        super(confluenceWebTester);
        setId(id);
    }

    public CommentHelper(final ConfluenceWebTester confluenceWebTester)
    {
        this(confluenceWebTester, 0);
    }

    public long getParentId()
    {
        return parentId;
    }

    public void setParentId(long parentId)
    {
        this.parentId = parentId;
    }

    public long getContentId()
    {
        return contentId;
    }

    public void setContentId(long contentId)
    {
        this.contentId = contentId;
    }

    public String getLastModifier()
    {
        return lastModifier;
    }

    public void setLastModifier(String lastModifier)
    {
        this.lastModifier = lastModifier;
    }

    public Date getLastModifiedDate()
    {
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate)
    {
        this.lastModifiedDate = lastModifiedDate;
    }

    protected RemoteComment toRemoteComment()
    {
        final RemoteComment remoteComment = new RemoteComment();

        remoteComment.setId(getId());
        remoteComment.setPageId(getContentId());
        remoteComment.setParentId(getParentId());
        remoteComment.setContent(getContent());
        remoteComment.setCreator(StringUtils.isBlank(getCreator()) ? confluenceWebTester.getCurrentUserName() : getCreator());

        if (null != getCreationDate())
        {
            final Calendar creationDate = Calendar.getInstance();

            creationDate.setTime(getCreationDate());
            remoteComment.setCreated(creationDate);
        }

        remoteComment.setModifier(StringUtils.isBlank(getLastModifier()) ? confluenceWebTester.getCurrentUserName() : getLastModifier());

        if (null != getLastModifiedDate())
        {
            final Calendar lastModifiedDate = Calendar.getInstance();

            lastModifiedDate.setTime(getLastModifiedDate());
            remoteComment.setModified(lastModifiedDate);
        }

        return remoteComment;
    }

    protected void populateHelper(final RemoteComment remoteComment)
    {
        setId(remoteComment.getId());
        setParentId(remoteComment.getParentId());
        setContentId(remoteComment.getPageId());
        setContent(remoteComment.getContent());
        setCreator(remoteComment.getCreator());
        setCreationDate(remoteComment.getCreated().getTime());
        setLastModifier(remoteComment.getModifier());
        setLastModifiedDate(remoteComment.getModified().getTime());
    }

    protected boolean storeRemoteContentAndUpdateHelper(
            final String soapSessionToken,
            final ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException
    {
        final RemoteComment storedRemoteComment;

        if (0 >= getContentId())
            throw new IllegalStateException("Comment persistence not allowed if contentId is lesser or equals to zero.");

        if (0 != getId())
            throw new IllegalStateException("At the time this method was written, we still do not have the ability to update comments via RPC. Therefore, I'm throwing this exception until we do.");

        storedRemoteComment = confluenceSoapService.addComment(soapSessionToken, toRemoteComment());
        setId(storedRemoteComment.getId());

        return 0 < getId();
    }

    protected boolean readRemoteContentAndUpdateHelper(
            final String soapSessionToken,
            final ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException
    {
        final RemoteComment remoteComment = confluenceSoapService.getComment(soapSessionToken, getId());
        final boolean success;

        if ((success = null != remoteComment))
            populateHelper(remoteComment);

        return success;
    }

    protected boolean deleteRemoteContent(
            final String soapSessionToken,
            final ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException
    {
        return confluenceSoapService.removeComment(soapSessionToken, getId());
    }
}
