/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest.helper;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.helper.AbstractSpaceContentHelper;
import com.atlassian.confluence.plugin.functest.helper.Attachable;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapService;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.RemoteAttachment;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.RemotePage;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.RemotePageSummary;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PageHelper
extends AbstractSpaceContentHelper
implements Attachable {
    private static final Logger LOG = Logger.getLogger((Class)PageHelper.class);
    private long parentId;
    private String lastModifier;
    private Date lastModifiedDate;

    public PageHelper(ConfluenceWebTester confluenceWebTester, long id) {
        super(confluenceWebTester, id);
    }

    public PageHelper(ConfluenceWebTester confluenceWebTester) {
        this(confluenceWebTester, 0L);
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildrenPageIds() {
        String soapSessionToken = null;
        if (this.getId() > 0L) {
            try {
                soapSessionToken = this.confluenceWebTester.loginToSoapService();
                ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
                RemotePageSummary[] remotePageSummaries = confluenceSoapService.getChildren(soapSessionToken, this.getId());
                if (null != remotePageSummaries) {
                    ArrayList<Long> pageIds = new ArrayList<Long>(remotePageSummaries.length);
                    for (int i = 0; i < remotePageSummaries.length; ++i) {
                        pageIds.add(new Long(remotePageSummaries[i].getId()));
                    }
                    ArrayList<Long> arrayList = pageIds;
                    return arrayList;
                }
            }
            catch (MalformedURLException mUrlE) {
                LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
            }
            catch (ServiceException se) {
                LOG.error((Object)"Service request denied.", (Throwable)se);
            }
            catch (RemoteException re) {
                LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
            }
            catch (IOException ioe) {
                LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
            }
            finally {
                this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
            }
        }
        return null;
    }

    protected RemotePage toRemotePage() {
        RemotePage remotePage = new RemotePage();
        remotePage.setId(this.getId());
        remotePage.setSpace(this.getSpaceKey());
        remotePage.setParentId(this.getParentId());
        remotePage.setTitle(this.getTitle());
        remotePage.setVersion(this.getVersion());
        remotePage.setContent(this.getContent());
        remotePage.setCreator(StringUtils.isBlank((String)this.getCreator()) ? this.confluenceWebTester.getCurrentUserName() : this.getCreator());
        if (null != this.getCreationDate()) {
            Calendar creationDate = Calendar.getInstance();
            creationDate.setTime(this.getCreationDate());
            remotePage.setCreated(creationDate);
        }
        remotePage.setModifier(StringUtils.isBlank((String)this.getLastModifier()) ? this.confluenceWebTester.getCurrentUserName() : this.getLastModifier());
        if (null != this.getLastModifiedDate()) {
            Calendar lastModifiedDate = Calendar.getInstance();
            lastModifiedDate.setTime(this.getLastModifiedDate());
            remotePage.setModified(lastModifiedDate);
        }
        return remotePage;
    }

    protected void populateHelper(RemotePage remotePage) {
        this.setId(remotePage.getId());
        this.setSpaceKey(remotePage.getSpace());
        this.setParentId(remotePage.getParentId());
        this.setTitle(remotePage.getTitle());
        this.setVersion(remotePage.getVersion());
        this.setContent(remotePage.getContent());
        this.setCreator(remotePage.getCreator());
        this.setCreationDate(remotePage.getCreated().getTime());
        this.setLastModifier(remotePage.getModifier());
        this.setLastModifiedDate(remotePage.getModified().getTime());
    }

    protected boolean storeRemoteContentAndUpdateHelper(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException {
        RemotePage remotePage = confluenceSoapService.storePage(soapSessionToken, this.toRemotePage());
        this.setId(remotePage.getId());
        this.setVersion(remotePage.getVersion());
        return 0L < this.getId();
    }

    protected boolean readRemoteContentAndUpdateHelper(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException {
        RemotePage remotePage = confluenceSoapService.getPage(soapSessionToken, this.getId());
        boolean success = null != remotePage;
        if (success) {
            this.populateHelper(remotePage);
        }
        return success;
    }

    protected boolean deleteRemoteContent(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws MalformedURLException, ServiceException, RemoteException {
        return confluenceSoapService.removePage(soapSessionToken, this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAttachmentFileNames() {
        String soapSessionToken = null;
        try {
            String[] attachmentNames;
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            RemoteAttachment[] remoteAttachments = confluenceSoapService.getAttachments(soapSessionToken, this.getId());
            if (null != remoteAttachments) {
                attachmentNames = new String[remoteAttachments.length];
                for (int i = 0; i < remoteAttachments.length; ++i) {
                    attachmentNames[i] = remoteAttachments[i].getFileName();
                }
            } else {
                attachmentNames = new String[]{};
            }
            String[] stringArray = attachmentNames;
            return stringArray;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long findBySpaceKeyAndTitle() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            RemotePage remotePage = confluenceSoapService.getPage(soapSessionToken, this.getSpaceKey(), this.getTitle());
            if (null != remotePage) {
                long l = remotePage.getId();
                return l;
            }
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return 0L;
    }
}

