/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.JWebUnitConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.helper.AttachmentHelper;
import com.atlassian.confluence.plugin.functest.helper.BandanaHelper;
import com.atlassian.confluence.plugin.functest.helper.BlogPostHelper;
import com.atlassian.confluence.plugin.functest.helper.CommentHelper;
import com.atlassian.confluence.plugin.functest.helper.GroupHelper;
import com.atlassian.confluence.plugin.functest.helper.HelperFactory;
import com.atlassian.confluence.plugin.functest.helper.IndexHelper;
import com.atlassian.confluence.plugin.functest.helper.MailServerHelper;
import com.atlassian.confluence.plugin.functest.helper.PageHelper;
import com.atlassian.confluence.plugin.functest.helper.SpaceHelper;
import com.atlassian.confluence.plugin.functest.helper.UserHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import net.sourceforge.jwebunit.junit.WebTestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class AbstractConfluencePluginWebTestCase
extends WebTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLicense() throws IOException {
        String string;
        URL licenseResource = ((Object)((Object)this)).getClass().getClassLoader().getResource("license.txt");
        BufferedReader reader = null;
        if (null == licenseResource) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            reader = new BufferedReader(new InputStreamReader(licenseResource.openStream(), "UTF-8"));
            IOUtils.copy((Reader)reader, (Writer)writer);
            string = ((Object)writer).toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    protected JWebUnitConfluenceWebTester createConfluenceWebTester() {
        JWebUnitConfluenceWebTester jWebUnitConfluenceWebTester;
        BufferedInputStream in = null;
        try {
            Properties webtesterProperties = new Properties();
            in = new BufferedInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("webtester.properties"));
            webtesterProperties.load(in);
            JWebUnitConfluenceWebTester jWebUnitConfluenceWebTester2 = new JWebUnitConfluenceWebTester(webtesterProperties.getProperty("confluence.webapp.protocol"), webtesterProperties.getProperty("confluence.webapp.host"), Integer.parseInt(webtesterProperties.getProperty("confluence.webapp.port")), webtesterProperties.getProperty("confluence.webapp.context.path"), webtesterProperties.getProperty("confluence.auth.admin.username"), webtesterProperties.getProperty("confluence.auth.admin.password"));
            if (StringUtils.isNotBlank((String)webtesterProperties.getProperty("confluence.plugin.jar")) && StringUtils.isNotBlank((String)webtesterProperties.getProperty("confluence.plugin.name"))) {
                jWebUnitConfluenceWebTester2.setConfluencePluginJar(new File(webtesterProperties.getProperty("confluence.plugin.jar")));
                jWebUnitConfluenceWebTester2.setConfluencePluginName(webtesterProperties.getProperty("confluence.plugin.name"));
            }
            if (StringUtils.isNotBlank((String)webtesterProperties.getProperty("confluence.data.export"))) {
                jWebUnitConfluenceWebTester2.setConfluenceBackupZip(new File(webtesterProperties.getProperty("confluence.data.export")));
            }
            jWebUnitConfluenceWebTester2.setLicenseString(this.getLicense());
            jWebUnitConfluenceWebTester = jWebUnitConfluenceWebTester2;
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException(ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return jWebUnitConfluenceWebTester;
    }

    protected void setUp() throws Exception {
        super.setUp();
        JWebUnitConfluenceWebTester confluenceWebTester = this.createConfluenceWebTester();
        this.tester = confluenceWebTester;
        this.beginAt("/");
        this.login(confluenceWebTester.getAdminUserName(), confluenceWebTester.getAdminPassword());
        this.installPlugin();
        this.updateLicense();
        this.restoreData();
    }

    protected void tearDown() throws Exception {
        this.logout();
        super.tearDown();
    }

    protected ConfluenceWebTester getConfluenceWebTester() {
        return (ConfluenceWebTester)this.tester;
    }

    protected void login(String username, String password) {
        this.getConfluenceWebTester().login(username, password);
    }

    protected void login() {
        this.getConfluenceWebTester().login();
    }

    protected void loginAsAdmin() {
        this.getConfluenceWebTester().login(this.getConfluenceWebTester().getAdminUserName(), this.getConfluenceWebTester().getAdminPassword());
    }

    protected void logout() {
        this.getConfluenceWebTester().logout();
    }

    public void updateLicense() throws IOException {
        this.getConfluenceWebTester().updateLicense();
    }

    public void refreshLicense() {
        this.getConfluenceWebTester().refreshLicense();
    }

    public void installPlugin() {
        this.getConfluenceWebTester().installPlugin();
    }

    public void restoreData() {
        this.getConfluenceWebTester().restoreData();
    }

    public void flushCaches() {
        this.getConfluenceWebTester().flushCaches();
    }

    public void reindex() {
        this.getIndexHelper().update();
    }

    public void assertResourceXsrfProtected(String resourcePath) {
        this.getConfluenceWebTester().assertResourceXsrfProtected(resourcePath);
    }

    public PageHelper getPageHelper(long pageId) {
        return HelperFactory.createPageHelper(this.getConfluenceWebTester(), pageId);
    }

    public PageHelper getPageHelper() {
        return HelperFactory.createPageHelper(this.getConfluenceWebTester());
    }

    public BlogPostHelper getBlogPostHelper(long blogPostId) {
        return HelperFactory.createBlogPostHelper(this.getConfluenceWebTester(), blogPostId);
    }

    public BlogPostHelper getBlogPostHelper() {
        return HelperFactory.createBlogPostHelper(this.getConfluenceWebTester());
    }

    public SpaceHelper getSpaceHelper(String spaceKey) {
        return HelperFactory.createSpaceHelper(this.getConfluenceWebTester(), spaceKey);
    }

    public SpaceHelper getSpaceHelper() {
        return HelperFactory.createSpaceHelper(this.getConfluenceWebTester());
    }

    public CommentHelper getCommentHelper(long commentId) {
        return HelperFactory.createCommentHelper(this.getConfluenceWebTester(), commentId);
    }

    public CommentHelper getCommentHelper() {
        return HelperFactory.createCommentHelper(this.getConfluenceWebTester());
    }

    public UserHelper getUserHelper(String userName) {
        return HelperFactory.createUserHelper(this.getConfluenceWebTester(), userName);
    }

    public UserHelper getUserHelper() {
        return HelperFactory.createUserHelper(this.getConfluenceWebTester());
    }

    public GroupHelper getGroupHelper(String groupName) {
        return HelperFactory.createGrouphelper(this.getConfluenceWebTester(), groupName);
    }

    public GroupHelper getGroupHelper() {
        return HelperFactory.createGrouphelper(this.getConfluenceWebTester());
    }

    public MailServerHelper getMailServerHelper(long id) {
        return HelperFactory.createMailServerHelper(this.getConfluenceWebTester(), id);
    }

    public MailServerHelper getMailServerHelper() {
        return HelperFactory.createMailServerHelper(this.getConfluenceWebTester());
    }

    public AttachmentHelper getAttachmentHelper() {
        return HelperFactory.createAttachmentHelper(this.getConfluenceWebTester());
    }

    public AttachmentHelper getAttachmentHelper(long id, String fileName) {
        return HelperFactory.createAttachmentHelper(this.getConfluenceWebTester(), id, fileName);
    }

    public BandanaHelper getBandanaHelper(String spaceKey, String bandanaKey) {
        return HelperFactory.createBandanaHelper(this.getConfluenceWebTester(), spaceKey, bandanaKey);
    }

    public BandanaHelper getBandanaHelper(String bandanaKey) {
        return HelperFactory.createBandanaHelper(this.getConfluenceWebTester(), "", bandanaKey);
    }

    public BandanaHelper getBandanaHelper() {
        return HelperFactory.createBandanaHelper(this.getConfluenceWebTester(), "");
    }

    public IndexHelper getIndexHelper() {
        return HelperFactory.createIndexHelper(this.getConfluenceWebTester());
    }
}

