package com.atlassian.confluence.plugin.functest.module.xmlrpc.rendering;

import com.atlassian.confluence.pages.wysiwyg.ConfluenceWysiwygConverter;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import org.apache.commons.lang.StringUtils;

public class RenderingHelperServiceDelegate implements RenderingHelperService
{
    private ConfluenceWysiwygConverter confluenceWysiwygConverter;

    private ContentEntityManager contentEntityManager;

    public void setConfluenceWysiwygConverter(ConfluenceWysiwygConverter confluenceWysiwygConverter)
    {
        this.confluenceWysiwygConverter = confluenceWysiwygConverter;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager)
    {
        this.contentEntityManager = contentEntityManager;
    }

    private ContentEntityObject getContentEntityObject(String pageId)
    {
        if (StringUtils.isNotBlank(pageId) && StringUtils.isNumeric(pageId))
            return contentEntityManager.getById(Long.parseLong(pageId));

        return null;
    }

    public String convertMarkupToXhtml(String authToken, String markup, String pageId)
    {
        return confluenceWysiwygConverter.convertWikiMarkupToXHtml(getContentEntityObject(pageId), markup);
    }

    public String convertXhtmlToMarkup(String authToken, String xhtml, String pageId)
    {
        return confluenceWysiwygConverter.convertXHtmlToWikiMarkup(getContentEntityObject(pageId), xhtml);
    }

    public String login(String s, String s1) throws RemoteException
    {
        return null;
    }

    public boolean logout(String s) throws RemoteException
    {
        return false;
    }
}
