package com.atlassian.confluence.plugin.functest;

import com.atlassian.confluence.plugin.functest.helper.AttachmentHelper;
import com.atlassian.confluence.plugin.functest.helper.BandanaHelper;
import com.atlassian.confluence.plugin.functest.helper.BlogPostHelper;
import com.atlassian.confluence.plugin.functest.helper.CommentHelper;
import com.atlassian.confluence.plugin.functest.helper.GroupHelper;
import com.atlassian.confluence.plugin.functest.helper.HelperFactory;
import com.atlassian.confluence.plugin.functest.helper.IndexHelper;
import com.atlassian.confluence.plugin.functest.helper.MailServerHelper;
import com.atlassian.confluence.plugin.functest.helper.PageHelper;
import com.atlassian.confluence.plugin.functest.helper.SpaceHelper;
import com.atlassian.confluence.plugin.functest.helper.UserHelper;
import net.sourceforge.jwebunit.junit.WebTestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;

public class AbstractConfluencePluginWebTestCase extends WebTestCase
{

    protected String getLicense() throws IOException
    {
        URL licenseResource = getClass().getClassLoader().getResource("license.txt");
        Reader reader = null;

        if (null == licenseResource)
            return null;

        try
        {
            final Writer writer = new StringWriter();

            reader = new BufferedReader(new InputStreamReader(licenseResource.openStream(), "UTF-8"));
            IOUtils.copy(reader, writer);

            return writer.toString();

        }
        finally
        {
            IOUtils.closeQuietly(reader);
        }
    }

    protected JWebUnitConfluenceWebTester createConfluenceWebTester()
    {
        InputStream in = null;

        try
        {
            final Properties webtesterProperties = new Properties();
            final JWebUnitConfluenceWebTester jWebUnitConfluenceWebTester;

            in = new BufferedInputStream(getClass().getClassLoader().getResourceAsStream("webtester.properties"));

            webtesterProperties.load(in);

            jWebUnitConfluenceWebTester = new JWebUnitConfluenceWebTester(
                    webtesterProperties.getProperty("confluence.webapp.protocol"),
                    webtesterProperties.getProperty("confluence.webapp.host"),
                    Integer.parseInt(webtesterProperties.getProperty("confluence.webapp.port")),
                    webtesterProperties.getProperty("confluence.webapp.context.path"),
                    webtesterProperties.getProperty("confluence.auth.admin.username"),
                    webtesterProperties.getProperty("confluence.auth.admin.password")
            );

            if (StringUtils.isNotBlank(webtesterProperties.getProperty("confluence.plugin.jar"))
                    && StringUtils.isNotBlank(webtesterProperties.getProperty("confluence.plugin.name")))
            {
                jWebUnitConfluenceWebTester.setConfluencePluginJar(new File(webtesterProperties.getProperty("confluence.plugin.jar")));
                jWebUnitConfluenceWebTester.setConfluencePluginName(webtesterProperties.getProperty("confluence.plugin.name"));
            }

            if (StringUtils.isNotBlank(webtesterProperties.getProperty("confluence.data.export")))
            {
                jWebUnitConfluenceWebTester.setConfluenceBackupZip(new File(webtesterProperties.getProperty("confluence.data.export")));
            }

            jWebUnitConfluenceWebTester.setLicenseString(getLicense());

            return jWebUnitConfluenceWebTester;

        }
        catch (final IOException ioe)
        {
            throw new RuntimeException(ioe);
        }
        finally
        {
            IOUtils.closeQuietly(in);
        }
    }

    protected void setUp() throws Exception
    {
        final JWebUnitConfluenceWebTester confluenceWebTester;

        super.setUp();
        tester = (confluenceWebTester = createConfluenceWebTester());

        beginAt("/");
        login(confluenceWebTester.getAdminUserName(), confluenceWebTester.getAdminPassword());
        installPlugin();
        updateLicense();
        restoreData();
    }

    protected void tearDown() throws Exception
    {
        logout();
        super.tearDown();
    }

    protected ConfluenceWebTester getConfluenceWebTester()
    {
        return (ConfluenceWebTester) tester;
    }

    protected void login(String username, String password)
    {
        getConfluenceWebTester().login(username, password);
    }

    protected void login()
    {
        getConfluenceWebTester().login();
    }

    protected void loginAsAdmin()
    {
        getConfluenceWebTester().login(getConfluenceWebTester().getAdminUserName(), getConfluenceWebTester().getAdminPassword());
    }

    protected void logout()
    {
        getConfluenceWebTester().logout();
    }

    public void updateLicense() throws IOException
    {
        getConfluenceWebTester().updateLicense();
    }

    public void refreshLicense()
    {
        getConfluenceWebTester().refreshLicense();
    }

    public void installPlugin()
    {
        getConfluenceWebTester().installPlugin();
    }

    public void restoreData()
    {
        getConfluenceWebTester().restoreData();
    }

    public void flushCaches()
    {
        getConfluenceWebTester().flushCaches();
    }

    /**
     * @deprecated Please use {@link com.atlassian.confluence.plugin.functest.helper.IndexHelper#update()} instead.
     */
    public void reindex()
    {
        getIndexHelper().update();
    }

    public void assertResourceXsrfProtected(String resourcePath)
    {
        getConfluenceWebTester().assertResourceXsrfProtected(resourcePath);
    }

    public PageHelper getPageHelper(long pageId)
    {
        return HelperFactory.createPageHelper(getConfluenceWebTester(), pageId);
    }

    public PageHelper getPageHelper()
    {
        return HelperFactory.createPageHelper(getConfluenceWebTester());
    }

    public BlogPostHelper getBlogPostHelper(long blogPostId)
    {
        return HelperFactory.createBlogPostHelper(getConfluenceWebTester(), blogPostId);
    }

    public BlogPostHelper getBlogPostHelper()
    {
        return HelperFactory.createBlogPostHelper(getConfluenceWebTester());
    }

    public SpaceHelper getSpaceHelper(String spaceKey)
    {
        return HelperFactory.createSpaceHelper(getConfluenceWebTester(), spaceKey);
    }

    public SpaceHelper getSpaceHelper()
    {
        return HelperFactory.createSpaceHelper(getConfluenceWebTester());
    }

    public CommentHelper getCommentHelper(long commentId)
    {
        return HelperFactory.createCommentHelper(getConfluenceWebTester(), commentId);
    }

    public CommentHelper getCommentHelper()
    {
        return HelperFactory.createCommentHelper(getConfluenceWebTester());
    }

    public UserHelper getUserHelper(String userName)
    {
        return HelperFactory.createUserHelper(getConfluenceWebTester(), userName);
    }

    public UserHelper getUserHelper()
    {
        return HelperFactory.createUserHelper(getConfluenceWebTester());
    }

    public GroupHelper getGroupHelper(String groupName)
    {
        return HelperFactory.createGrouphelper(getConfluenceWebTester(), groupName);
    }

    public GroupHelper getGroupHelper()
    {
        return HelperFactory.createGrouphelper(getConfluenceWebTester());
    }

    public MailServerHelper getMailServerHelper(long id)
    {
        return HelperFactory.createMailServerHelper(getConfluenceWebTester(), id);
    }

    public MailServerHelper getMailServerHelper()
    {
        return HelperFactory.createMailServerHelper(getConfluenceWebTester());
    }

    public AttachmentHelper getAttachmentHelper()
    {
        return HelperFactory.createAttachmentHelper(getConfluenceWebTester());
    }

    public AttachmentHelper getAttachmentHelper(long id, String fileName)
    {
        return HelperFactory.createAttachmentHelper(getConfluenceWebTester(), id, fileName);
    }

    public BandanaHelper getBandanaHelper(String spaceKey, String bandanaKey)
    {
        return HelperFactory.createBandanaHelper(getConfluenceWebTester(), spaceKey, bandanaKey);
    }

    public BandanaHelper getBandanaHelper(String bandanaKey)
    {
        return HelperFactory.createBandanaHelper(getConfluenceWebTester(), "", bandanaKey);
    }

    public BandanaHelper getBandanaHelper()
    {
        return HelperFactory.createBandanaHelper(getConfluenceWebTester(), "");
    }

    public IndexHelper getIndexHelper()
    {
        return HelperFactory.createIndexHelper(getConfluenceWebTester());
    }

}
