/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.module.xmlrpc.mail;

import com.atlassian.confluence.plugin.module.xmlrpc.mail.MailServerHelperService;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.atlassian.user.User;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MailServerHelperServiceDelegate
implements MailServerHelperService {
    private MailServerManager mailServerManager;
    private PermissionManager permissionManager;

    public MailServerManager getMailServerManager() {
        return this.mailServerManager;
    }

    public void setMailServerManager(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    private boolean isCurrentUserAnAdmin() {
        User user = AuthenticatedUserThreadLocal.getUser();
        return null != user && this.getPermissionManager().hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    private SMTPMailServer toSMTPMailServer(Map mailServerStructure) throws RemoteException {
        SMTPMailServerImpl smtpMailServer = new SMTPMailServerImpl(new Long((String)mailServerStructure.get("id")), (String)mailServerStructure.get("name"), null, (String)mailServerStructure.get("fromAddress"), (String)mailServerStructure.get("prefix"), StringUtils.isNotBlank((String)((String)mailServerStructure.get("jndiLocation"))), (String)mailServerStructure.get("jndiLocation"), (String)mailServerStructure.get("userName"), (String)mailServerStructure.get("password"));
        String[] smtpServerAddressParts = StringUtils.split((String)((String)mailServerStructure.get("address")), (char)':');
        if (smtpServerAddressParts.length == 1) {
            smtpMailServer.setHostname(smtpServerAddressParts[0]);
            smtpMailServer.setSmtpPort("25");
        } else if (smtpServerAddressParts.length == 2) {
            smtpMailServer.setHostname(smtpServerAddressParts[0]);
            smtpMailServer.setSmtpPort(smtpServerAddressParts[1]);
        } else {
            throw new RemoteException("Invalid address specified: " + mailServerStructure.get("address"));
        }
        return smtpMailServer;
    }

    private Hashtable toHashtable(SMTPMailServer smtpMailServer) throws RemoteException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (null != smtpMailServer.getId()) {
            hashtable.put("id", String.valueOf(smtpMailServer.getId()));
        }
        if (null != smtpMailServer.getName()) {
            hashtable.put("name", smtpMailServer.getName());
        }
        if (null != smtpMailServer.getDefaultFrom()) {
            hashtable.put("fromAddress", smtpMailServer.getDefaultFrom());
        }
        if (null != smtpMailServer.getPrefix()) {
            hashtable.put("prefix", smtpMailServer.getPrefix());
        }
        if (null != smtpMailServer.getJndiLocation()) {
            hashtable.put("jndiLocation", smtpMailServer.getJndiLocation());
        }
        if (null != smtpMailServer.getUsername()) {
            hashtable.put("userName", smtpMailServer.getUsername());
        }
        if (null != smtpMailServer.getPassword()) {
            hashtable.put("password", smtpMailServer.getPassword());
        }
        if (null != smtpMailServer.getHostname() && null != smtpMailServer.getSmtpPort()) {
            hashtable.put("address", smtpMailServer.getHostname() + ":" + smtpMailServer.getSmtpPort());
        }
        return hashtable;
    }

    private void validateMailServer(SMTPMailServer smtpMailServer) throws RemoteException {
        if (StringUtils.isBlank((String)smtpMailServer.getName())) {
            throw new RemoteException("Mail server name not specified.");
        }
        if (StringUtils.isBlank((String)smtpMailServer.getDefaultFrom())) {
            throw new RemoteException("From address not specified.");
        }
        if (StringUtils.isBlank((String)smtpMailServer.getPrefix())) {
            throw new RemoteException("Prefix not specified.");
        }
        if (StringUtils.isBlank((String)smtpMailServer.getHostname()) && StringUtils.isBlank((String)smtpMailServer.getJndiLocation())) {
            throw new RemoteException("Server address/JNDI location not specified.");
        }
    }

    public String createMailServer(String authToken, Hashtable mailServerStructure) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        SMTPMailServer smtpMailServer = this.toSMTPMailServer(mailServerStructure);
        if (null != smtpMailServer.getId() && smtpMailServer.getId() != 0L) {
            throw new RemoteException("Unable to create SMTP server. It seems that there is an ID associated the specified structure: " + smtpMailServer.getId());
        }
        this.validateMailServer(smtpMailServer);
        try {
            return String.valueOf(this.getMailServerManager().create((MailServer)smtpMailServer));
        }
        catch (MailException me) {
            throw new RemoteException((Throwable)me);
        }
    }

    public boolean updateMailServer(String authToken, Hashtable mailServerStructure) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        SMTPMailServer smtpMailServer = this.toSMTPMailServer(mailServerStructure);
        if (null == smtpMailServer.getId()) {
            throw new RemoteException("Unable to update SMTP server. There seems to be no ID associated the specified structure");
        }
        this.validateMailServer(smtpMailServer);
        try {
            this.getMailServerManager().update((MailServer)smtpMailServer);
            return true;
        }
        catch (MailException me) {
            throw new RemoteException((Throwable)me);
        }
    }

    public Hashtable readMailServer(String authToken, String mailServerId) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        try {
            List smtpMailServers = this.getMailServerManager().getSmtpMailServers();
            if (null != smtpMailServers) {
                Iterator i = smtpMailServers.iterator();
                while (i.hasNext()) {
                    SMTPMailServer smtpMailServer = (SMTPMailServer)i.next();
                    if (!StringUtils.equals((String)String.valueOf(smtpMailServer.getId()), (String)mailServerId)) continue;
                    return this.toHashtable(smtpMailServer);
                }
            }
            return null;
        }
        catch (MailException me) {
            throw new RuntimeException(me);
        }
    }

    public boolean deleteMailServer(String authToken, String mailServerId) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        try {
            this.getMailServerManager().delete(new Long(mailServerId));
            return true;
        }
        catch (MailException me) {
            throw new RuntimeException(me);
        }
    }

    public Hashtable getMailServerIdsAndNames(String authToken) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        try {
            List smtpMailServers = this.getMailServerManager().getSmtpMailServers();
            Hashtable<String, String> mailServerIdsAndNames = new Hashtable<String, String>();
            if (null != smtpMailServers) {
                Iterator i = smtpMailServers.iterator();
                while (i.hasNext()) {
                    SMTPMailServer smtpMailServer = (SMTPMailServer)i.next();
                    mailServerIdsAndNames.put(String.valueOf(smtpMailServer.getId()), smtpMailServer.getName());
                }
            }
            return mailServerIdsAndNames;
        }
        catch (MailException me) {
            throw new RuntimeException(me);
        }
    }

    public String login(String s, String s1) throws RemoteException {
        return null;
    }

    public boolean logout(String s) throws RemoteException {
        return false;
    }
}

