/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.module.xmlrpc.bandana;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.plugin.module.xmlrpc.bandana.BandanaHelperService;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class BandanaHelperServiceDelegate
implements BandanaHelperService {
    private BandanaManager bandanaManager;
    private PermissionManager permissionManager;

    public BandanaManager getBandanaManager() {
        return this.bandanaManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    private boolean isCurrentUserAnAdmin() {
        User user = AuthenticatedUserThreadLocal.getUser();
        return null != user && this.getPermissionManager().hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    private void checkBandanaKey(String key) throws RemoteException {
        if (StringUtils.isBlank((String)key)) {
            throw new RemoteException("Key must not be blank");
        }
    }

    private ConfluenceBandanaContext getBandanaContext(String spaceKey) {
        return StringUtils.isBlank((String)spaceKey) ? new ConfluenceBandanaContext() : new ConfluenceBandanaContext(spaceKey);
    }

    public Boolean setValue(String authenticationToken, String spaceKey, String key, String value) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        this.checkBandanaKey(key);
        this.getBandanaManager().setValue((BandanaContext)this.getBandanaContext(spaceKey), key, (Object)value);
        return Boolean.TRUE;
    }

    public Boolean removeValue(String authenticationToken, String spaceKey, String key) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        this.checkBandanaKey(key);
        this.getBandanaManager().setValue((BandanaContext)this.getBandanaContext(spaceKey), key, null);
        return Boolean.TRUE;
    }

    public Map getValue(String authenticationToken, String spaceKey, String key) throws RemoteException {
        if (!this.isCurrentUserAnAdmin()) {
            throw new RemoteException("You do not have admin permission.");
        }
        this.checkBandanaKey(key);
        Hashtable<String, Object> bandanaEntry = new Hashtable<String, Object>();
        Object bandanaValue = this.getBandanaManager().getValue((BandanaContext)this.getBandanaContext(spaceKey), key);
        if (null != bandanaValue) {
            if (StringUtils.isNotBlank((String)spaceKey)) {
                bandanaEntry.put("spaceKey", spaceKey);
            }
            bandanaEntry.put("key", key);
            bandanaEntry.put("value", bandanaValue);
        }
        return bandanaEntry;
    }

    public String login(String s, String s1) throws RemoteException {
        return null;
    }

    public boolean logout(String s) throws RemoteException {
        return false;
    }
}

