/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.helper;

import com.atlassian.confluence.ConfluenceSoapService;
import com.atlassian.confluence.RemoteBlogEntrySummary;
import com.atlassian.confluence.RemotePageSummary;
import com.atlassian.confluence.RemoteSpace;
import com.atlassian.confluence.plugin.helper.AbstractHelper;
import com.atlassian.confluence.spaces.SpaceType;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.rpc.ServiceException;

public class SpaceHelper
extends AbstractHelper {
    public static final String TYPE_GLOBAL = SpaceType.GLOBAL.toString();
    public static final String TYPE_PERSONAL = SpaceType.PERSONAL.toString();
    private String key;
    private String type;
    private String name;
    private String description;
    private long homePageId;

    public SpaceHelper() {
        this((String)null);
    }

    public SpaceHelper(String spaceKey) {
        this.setKey(spaceKey);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getHomePageId() {
        return this.homePageId;
    }

    public void setHomePageId(long homePageId) {
        this.homePageId = homePageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPageIds() {
        HashSet<Long> pageIdSet = new HashSet<Long>();
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            RemotePageSummary[] remotePageSummaries = confluenceSoapService.getPages(soapSessionToken, this.getKey());
            if (null != remotePageSummaries) {
                for (int i = 0; i < remotePageSummaries.length; ++i) {
                    pageIdSet.add(new Long(remotePageSummaries[i].getId()));
                }
            }
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return pageIdSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getBlogIds() {
        HashSet<Long> blogIdSet = new HashSet<Long>();
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            RemoteBlogEntrySummary[] remoteBlogEntrySummaries = confluenceSoapService.getBlogEntries(soapSessionToken, this.getKey());
            if (null != remoteBlogEntrySummaries) {
                for (int i = 0; i < remoteBlogEntrySummaries.length; ++i) {
                    blogIdSet.add(new Long(remoteBlogEntrySummaries[i].getId()));
                }
            }
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return blogIdSet;
    }

    protected RemoteSpace toRemoteSpace() {
        RemoteSpace remoteSpace = new RemoteSpace();
        remoteSpace.setKey(this.getKey());
        remoteSpace.setType(this.getType());
        remoteSpace.setName(this.getName());
        remoteSpace.setDescription(this.getDescription());
        remoteSpace.setHomePage(this.getHomePageId());
        return remoteSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            confluenceSoapService.addSpace(soapSessionToken, this.toRemoteSpace());
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            RemoteSpace remoteSpace = confluenceSoapService.getSpace(soapSessionToken, this.getKey());
            this.setKey(remoteSpace.getKey());
            this.setType(remoteSpace.getType());
            this.setName(remoteSpace.getName());
            this.setDescription(remoteSpace.getDescription());
            this.setHomePageId(remoteSpace.getHomePage());
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    public boolean update() {
        throw new UnsupportedOperationException("The operation would not be supported until com.atlassian.confluence.rpc.soap.ConfluenceSoapService#storeSpace stops calling addSpace");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            boolean bl = confluenceSoapService.removeSpace(soapSessionToken, this.getKey());
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }
}

