/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.helper;

import com.atlassian.confluence.ConfluenceSoapService;
import com.atlassian.confluence.RemoteComment;
import com.atlassian.confluence.plugin.helper.Commentable;
import com.atlassian.confluence.plugin.helper.ContentHelper;
import com.atlassian.confluence.plugin.helper.Labellable;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.ServiceException;

public abstract class AbstractSpaceContentHelper
extends ContentHelper
implements Labellable,
Commentable {
    private String title;
    private String spaceKey;
    private List labels;

    protected AbstractSpaceContentHelper(long id) {
        super(id);
        this.setLabels(new ArrayList());
    }

    protected AbstractSpaceContentHelper() {
        this(0L);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public List getLabels() {
        return this.labels;
    }

    public void setLabels(List labels) {
        this.labels = labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentRendered() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            String string = confluenceSoapService.renderContent(soapSessionToken, this.getSpaceKey(), this.getId(), this.getContent());
            return string;
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return null;
    }

    public void markFavourite() {
        this.confluenceWebTester.gotoPage("/pages/viewpage.action?pageId=" + this.getId());
        this.confluenceWebTester.assertTextPresent("addfavourite.action");
        this.confluenceWebTester.gotoPage("/labels/addfavourite.action?entityId=" + this.getId());
        this.confluenceWebTester.assertTextPresent("removefavourite.action");
    }

    public void addWatch() {
        this.confluenceWebTester.gotoPage("/pages/viewpage.action?pageId=" + this.getId());
        this.confluenceWebTester.assertTextPresent("addpagenotification.action");
        this.confluenceWebTester.gotoPage("/pages/addpagenotification.action?pageId=" + this.getId());
        this.confluenceWebTester.assertTextPresent("removepagenotification");
    }

    public boolean isWatched() {
        this.confluenceWebTester.gotoPage("/pages/viewpage.action?pageId=" + this.getId());
        return this.confluenceWebTester.getDialog().getResponseText().indexOf("removepagenotification.action") >= 0;
    }

    public boolean isFavorite() {
        this.confluenceWebTester.gotoPage("/pages/viewpage.action?pageId=" + this.getId());
        return this.confluenceWebTester.getDialog().getResponseText().indexOf("removefavourite.action") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCommentIds() {
        if (0L < this.getId()) {
            String soapSessionToken = null;
            try {
                soapSessionToken = this.confluenceWebTester.loginToSoapService();
                ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
                RemoteComment[] remoteComments = confluenceSoapService.getComments(soapSessionToken, this.getId());
                if (null != remoteComments) {
                    ArrayList<Long> commentIds = new ArrayList<Long>(remoteComments.length);
                    for (int i = 0; i < remoteComments.length; ++i) {
                        commentIds.add(new Long(remoteComments[i].getId()));
                    }
                    ArrayList<Long> arrayList = commentIds;
                    return arrayList;
                }
            }
            catch (MalformedURLException mUrlE) {
                this.handleInvalidSoapServiceEndpointException(mUrlE);
            }
            catch (ServiceException se) {
                this.handleInvalidSoapServiceException(se);
            }
            catch (RemoteException re) {
                this.handleRemoteException(re);
            }
            finally {
                this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected List readLabels() throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLabels() throws RemoteException {
        if (0L != this.getId()) {
            List remoteLabels = this.readLabels();
            String soapSessionToken = null;
            try {
                soapSessionToken = this.confluenceWebTester.loginToSoapService();
                ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
                Iterator i = this.getLabels().iterator();
                while (i.hasNext()) {
                    String label = (String)i.next();
                    if (remoteLabels.contains(label)) continue;
                    confluenceSoapService.addLabelByName(soapSessionToken, label, this.getId());
                }
                i = remoteLabels.iterator();
                while (i.hasNext()) {
                    String remoteLabel = (String)i.next();
                    if (this.getLabels().contains(remoteLabel)) continue;
                    confluenceSoapService.removeLabelByName(soapSessionToken, remoteLabel, this.getId());
                }
            }
            catch (MalformedURLException mUrlE) {
                this.handleInvalidSoapServiceEndpointException(mUrlE);
            }
            catch (ServiceException se) {
                this.handleInvalidSoapServiceException(se);
            }
            catch (RemoteException re) {
                this.handleRemoteException(re);
            }
            finally {
                this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
            }
        }
    }

    protected boolean saveOrUpdate() {
        try {
            if (super.saveOrUpdate()) {
                this.updateLabels();
                return true;
            }
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        return false;
    }

    public boolean read() {
        if (super.read()) {
            try {
                this.setLabels(this.readLabels());
                return true;
            }
            catch (RemoteException re) {
                this.handleRemoteException(re);
            }
        }
        return false;
    }
}

