/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin;

import com.atlassian.confluence.ConfluenceSoapService;
import com.atlassian.confluence.ConfluenceSoapServiceServiceLocator;
import com.atlassian.confluence.plugin.helper.AttachmentHelper;
import com.atlassian.confluence.plugin.helper.BandanaHelper;
import com.atlassian.confluence.plugin.helper.BlogPostHelper;
import com.atlassian.confluence.plugin.helper.CommentHelper;
import com.atlassian.confluence.plugin.helper.GroupHelper;
import com.atlassian.confluence.plugin.helper.MailServerHelper;
import com.atlassian.confluence.plugin.helper.PageHelper;
import com.atlassian.confluence.plugin.helper.SpaceHelper;
import com.atlassian.confluence.plugin.helper.UserHelper;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebForm;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Vector;
import javax.xml.rpc.ServiceException;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ConfluenceWebTester
extends WebTester {
    private static final long MAX_REINDEXING_DURATION = 900000L;
    private static final Logger LOGGER = Logger.getLogger((Class)ConfluenceWebTester.class);
    private String adminUserName;
    private String adminPassword;
    private String protocol;
    private String hostName;
    private int port;
    private String contextPath;
    private String soapServicePath;
    private String currentUserName;
    private String currentPassword;
    private File confluencePluginJar;
    private String confluencePluginName;
    private File confluenceBackupZip;
    private String licenseString;

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public void setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getSoapServicePath() {
        return this.soapServicePath;
    }

    public void setSoapServicePath(String soapServicePath) {
        this.soapServicePath = soapServicePath;
    }

    public String getCurrentUserName() {
        return this.currentUserName;
    }

    public void setCurrentUserName(String currentUserName) {
        this.currentUserName = currentUserName;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public File getConfluencePluginJar() {
        return this.confluencePluginJar;
    }

    public void setConfluencePluginJar(File confluencePluginJar) {
        this.confluencePluginJar = confluencePluginJar;
    }

    public String getConfluencePluginName() {
        return this.confluencePluginName;
    }

    public void setConfluencePluginName(String confluencePluginName) {
        this.confluencePluginName = confluencePluginName;
    }

    public File getConfluenceBackupZip() {
        return this.confluenceBackupZip;
    }

    public void setConfluenceBackupZip(File confluenceBackupZip) {
        this.confluenceBackupZip = confluenceBackupZip;
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    public String getBaseUrl() {
        return this.getProtocol() + "://" + this.getHostName() + ':' + this.getPort() + this.getContextPath();
    }

    public String getSoapServiceLocation() {
        return this.getBaseUrl() + this.getSoapServicePath();
    }

    public String getXmlRpcServiceLocation() {
        return this.getBaseUrl() + "/rpc/xmlrpc";
    }

    public void login(String username, String password) {
        this.setCurrentUserName(username);
        this.setCurrentPassword(password);
        this.login();
    }

    public void login() {
        this.gotoPage("/login.action");
        this.assertTextNotPresent("You are currently logged in");
        this.setWorkingForm("loginform");
        this.setFormElement("os_username", this.getCurrentUserName());
        this.setFormElement("os_password", this.getCurrentPassword());
        this.submit("login");
        this.assertLinkPresentWithText("Log Out");
    }

    public void logout() {
        this.gotoPage("/logout.action");
        this.assertTextPresent("You have been successfully logged out and any automatic logins removed.");
    }

    public XmlRpcClient getXmlRpcClient() throws MalformedURLException {
        return new XmlRpcClient(this.getXmlRpcServiceLocation());
    }

    public String loginToXmlRpcService(String userName, String password) throws XmlRpcException, IOException {
        XmlRpcClient xmlRpcClient = this.getXmlRpcClient();
        return (String)xmlRpcClient.execute("confluence1.login", new Vector<String>(Arrays.asList(userName, password)));
    }

    public void logoutFromXmlRpcService(String authenticationToken) {
        if (StringUtils.isNotBlank((String)authenticationToken)) {
            try {
                XmlRpcClient xmlRpcClient = this.getXmlRpcClient();
                xmlRpcClient.execute("confluence1.logout", new Vector<String>(Arrays.asList(authenticationToken)));
            }
            catch (XmlRpcException xre) {
                this.handleInvalidXmlRpcServiceException(xre);
            }
            catch (IOException ioe) {
                this.handleIOException(ioe);
            }
        }
    }

    public String loginToXmlRPcService() throws XmlRpcException, IOException {
        return this.loginToXmlRpcService(this.getCurrentUserName(), this.getCurrentPassword());
    }

    public ConfluenceSoapService getConfluenceSoapService() throws MalformedURLException, ServiceException {
        ConfluenceSoapServiceServiceLocator confluenceSoapServiceServiceLocator = new ConfluenceSoapServiceServiceLocator();
        return confluenceSoapServiceServiceLocator.getConfluenceserviceV1(new URL(this.getSoapServiceLocation()));
    }

    public String loginToSoapService(String userName, String password) throws MalformedURLException, ServiceException, RemoteException {
        ConfluenceSoapService confluenceSoapService = this.getConfluenceSoapService();
        return StringUtils.isNotBlank((String)userName) ? confluenceSoapService.login(userName, password) : null;
    }

    public String loginToSoapService() throws MalformedURLException, ServiceException, RemoteException {
        return this.loginToSoapService(this.getCurrentUserName(), this.getCurrentPassword());
    }

    public void logoutFromSoapService(String authenticationToken) {
        try {
            if (null != authenticationToken) {
                this.getConfluenceSoapService().logout(authenticationToken);
            }
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
    }

    protected void updateLicense() throws IOException {
        String licenseString = this.getLicenseString();
        if (StringUtils.isNotBlank((String)licenseString)) {
            this.gotoPage("/admin/console.action");
            this.clickLinkWithText("License Details");
            this.setWorkingForm("updateLicenseForm");
            this.setFormElement("licenseString", licenseString);
            this.submit("update");
            this.assertTextNotPresent("License string is too short");
            this.assertTextNotPresent("License was not valid");
        }
    }

    protected void refreshLicense() {
        this.gotoPage("/admin/refreshlicensing.action");
    }

    protected void installPlugin() {
        File confluencePluginJar = this.getConfluencePluginJar();
        if (null != confluencePluginJar && confluencePluginJar.isFile()) {
            this.gotoPage("/admin/plugins.action");
            this.assertTextPresent("Manage Plugins");
            this.setWorkingForm("plugin-upload");
            this.getDialog().getForm().setParameter("file_0", new UploadFileSpec[]{new UploadFileSpec(this.getConfluencePluginJar())});
            this.submit("confirm");
            this.assertLinkPresentWithText(this.getConfluencePluginName());
        }
    }

    protected void restoreData() {
        File confluenceBackupZip = this.getConfluenceBackupZip();
        if (null != confluenceBackupZip && confluenceBackupZip.isFile()) {
            try {
                this.gotoPage("/admin/backup.action?synchronous=true");
                this.assertTextPresent("Restore Confluence Data");
                WebForm[] forms = this.getDialog().getResponse().getForms();
                WebForm restoreForm = forms[2];
                restoreForm.setParameter("file", new UploadFileSpec[]{new UploadFileSpec(confluenceBackupZip)});
                restoreForm.submit();
                this.reindex();
            }
            catch (SAXException saxE) {
                throw new RuntimeException(saxE);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public void reindex() {
        long startIndexingTime = System.currentTimeMillis();
        this.gotoPage("/admin/reindex.action");
        while (System.currentTimeMillis() - startIndexingTime < 900000L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.gotoPage("/admin/indexsummary.action");
            Element pctComplete = this.getDialog().getElement("percentComplete");
            if (pctComplete == null || Integer.parseInt(pctComplete.getTextContent()) != 100) continue;
            break;
        }
    }

    public void flushCaches() {
        this.gotoPage("/admin/console.action");
        this.clickLinkWithText("Cache Statistics");
        this.clickLinkWithText("Flush all");
    }

    protected PageHelper getPageHelper(long pageId) {
        PageHelper pageHelper = new PageHelper();
        pageHelper.setId(pageId);
        pageHelper.setConfluenceWebTester(this);
        return pageHelper;
    }

    protected PageHelper getPageHelper() {
        return this.getPageHelper(0L);
    }

    protected BlogPostHelper getBlogPostHelper(long blogPostId) {
        BlogPostHelper blogPostHelper = new BlogPostHelper(blogPostId);
        blogPostHelper.setId(blogPostId);
        blogPostHelper.setConfluenceWebTester(this);
        return blogPostHelper;
    }

    protected BlogPostHelper getBlogPostHelper() {
        return this.getBlogPostHelper(0L);
    }

    protected SpaceHelper getSpaceHelper(String spaceKey) {
        SpaceHelper spaceHelper = new SpaceHelper(spaceKey);
        spaceHelper.setKey(spaceKey);
        spaceHelper.setConfluenceWebTester(this);
        return spaceHelper;
    }

    protected SpaceHelper getSpaceHelper() {
        return this.getSpaceHelper(null);
    }

    protected CommentHelper getCommentHelper(long commentId) {
        CommentHelper commentHelper = new CommentHelper(commentId);
        commentHelper.setId(commentId);
        commentHelper.setConfluenceWebTester(this);
        return commentHelper;
    }

    protected CommentHelper getCommentHelper() {
        return this.getCommentHelper(0L);
    }

    protected UserHelper getUserHelper(String userName) {
        UserHelper userHelper = new UserHelper(userName);
        userHelper.setName(userName);
        userHelper.setConfluenceWebTester(this);
        return userHelper;
    }

    protected UserHelper getUserHelper() {
        return this.getUserHelper(null);
    }

    protected GroupHelper getGroupHelper(String groupName) {
        GroupHelper groupHelper = new GroupHelper(groupName);
        groupHelper.setName(groupName);
        groupHelper.setConfluenceWebTester(this);
        return groupHelper;
    }

    protected GroupHelper getGroupHelper() {
        return this.getGroupHelper(null);
    }

    protected MailServerHelper getMailServerHelper(long id) {
        MailServerHelper mailServerHelper = new MailServerHelper(id);
        mailServerHelper.setConfluenceWebTester(this);
        return mailServerHelper;
    }

    protected MailServerHelper getMailServerHelper() {
        return this.getMailServerHelper(0L);
    }

    protected AttachmentHelper getAttachmentHelper(long id, String fileName) {
        AttachmentHelper attachmentHelper = new AttachmentHelper(id, fileName);
        attachmentHelper.setConfluenceWebTester(this);
        return attachmentHelper;
    }

    protected AttachmentHelper getAttachmentHelper() {
        return this.getAttachmentHelper(0L, null);
    }

    protected BandanaHelper getBandanaHelper(String spaceKey, String bandanaKey) {
        BandanaHelper bandanaHelper = new BandanaHelper(spaceKey, bandanaKey);
        bandanaHelper.setConfluenceWebTester(this);
        return bandanaHelper;
    }

    protected BandanaHelper getBandanaHelper(String bandanaKey) {
        return this.getBandanaHelper("", bandanaKey);
    }

    protected BandanaHelper getBandanaHelper() {
        return this.getBandanaHelper("", null);
    }

    public void handleInvalidSoapServiceEndpointException(MalformedURLException mUrlE) {
        if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
            LOGGER.error((Object)("Invalid Confluence SOAP service endpoint configured: " + this.getSoapServiceLocation()), (Throwable)mUrlE);
        }
    }

    public void handleInvalidXmlRpcServiceEndpointException(MalformedURLException mUrlE) {
        if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
            LOGGER.error((Object)("Invalid Confluence XMLRPC service endpoint configured: " + this.getSoapServiceLocation()), (Throwable)mUrlE);
        }
    }

    public void handleInvalidSoapServiceException(ServiceException se) {
        if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
            LOGGER.error((Object)"Confluence SOAP service borked.", (Throwable)se);
        }
    }

    public void handleInvalidXmlRpcServiceException(XmlRpcException e) {
        if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
            LOGGER.error((Object)"Confluence XMLRPC service borked.", (Throwable)e);
        }
    }

    public void handleRemoteException(RemoteException re) {
        if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
            LOGGER.error((Object)"Requested operation could not be performed.", (Throwable)re);
        }
    }

    public void handleIOException(IOException e) {
        if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
            LOGGER.error((Object)"Unable to read/write.", (Throwable)e);
        }
    }
}

