package com.atlassian.confluence.plugin.helper;

import com.atlassian.confluence.ConfluenceSoapService;

import javax.xml.rpc.ServiceException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;

public class GroupHelper extends AbstractHelper {

    private String name;

    public GroupHelper(final String name) {
        setName(name);
    }

    public GroupHelper() {
        this(null);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean create() {
        String soapSessionToken = null;
        ConfluenceSoapService confluenceSoapService;

        try {
            soapSessionToken = confluenceWebTester.loginToSoapService();
            confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

            confluenceSoapService.addGroup(soapSessionToken, getName());
            return true;

        } catch (final MalformedURLException mUrlE) {
            handleInvalidSoapServiceEndpointException(mUrlE);
        } catch (final ServiceException se) {
            handleInvalidSoapServiceException(se);
        } catch (final RemoteException re) {
            handleRemoteException(re);
        } finally {
            confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }

        return false;
    }

    public boolean read() {
        String soapSessionToken = null;
        ConfluenceSoapService confluenceSoapService;

        try {
            soapSessionToken = confluenceWebTester.loginToSoapService();
            confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

            return confluenceSoapService.hasGroup(soapSessionToken, getName());
            
        } catch (final MalformedURLException mUrlE) {
            handleInvalidSoapServiceEndpointException(mUrlE);
        } catch (final ServiceException se) {
            handleInvalidSoapServiceException(se);
        } catch (final RemoteException re) {
            handleRemoteException(re);
        } finally {
            confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }

        return false;
    }

    public boolean update() {
        throw new UnsupportedOperationException("Group edits currently not supported.");
    }

    public boolean delete() {
        String soapSessionToken = null;
        ConfluenceSoapService confluenceSoapService;

        try {
            soapSessionToken = confluenceWebTester.loginToSoapService();
            confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

            return confluenceSoapService.removeGroup(soapSessionToken, getName(), null);

        } catch (final MalformedURLException mUrlE) {
            handleInvalidSoapServiceEndpointException(mUrlE);
        } catch (final ServiceException se) {
            handleInvalidSoapServiceException(se);
        } catch (final RemoteException re) {
            handleRemoteException(re);
        } finally {
            confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }

        return false;
    }
}
