package com.atlassian.confluence.plugin.helper;

import com.atlassian.confluence.plugin.ConfluenceWebTester;

import javax.xml.rpc.ServiceException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.io.IOException;

import org.apache.xmlrpc.XmlRpcException;

public abstract class AbstractHelper implements Helper {

    protected ConfluenceWebTester confluenceWebTester;

    protected AbstractHelper(final ConfluenceWebTester confluenceWebTester) {
        setConfluenceWebTester(confluenceWebTester);
    }

    protected AbstractHelper() {
        this(null);
    }

    public ConfluenceWebTester getConfluenceWebTester() {
        return confluenceWebTester;
    }

    public void setConfluenceWebTester(ConfluenceWebTester confluenceWebTester) {
        this.confluenceWebTester = confluenceWebTester;
    }

    public void handleInvalidSoapServiceEndpointException(MalformedURLException mUrlE) {
        confluenceWebTester.handleInvalidSoapServiceEndpointException(mUrlE);
    }

    public void handleInvalidXmlRpcServiceEndpointException(MalformedURLException mUrlE) {
        confluenceWebTester.handleInvalidXmlRpcServiceEndpointException(mUrlE);
    }

    public void handleInvalidSoapServiceException(ServiceException se) {
        confluenceWebTester.handleInvalidSoapServiceException(se);
    }

    public void handleInvalidXmlRpcServiceException(XmlRpcException e) {
        confluenceWebTester.handleInvalidXmlRpcServiceException(e);
    }

    public void handleRemoteException(RemoteException re) {
        confluenceWebTester.handleRemoteException(re);
    }

    public void handleIOException(IOException e) {
        confluenceWebTester.handleIOException(e);
    }
}
