/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.office;

import com.atlassian.confluence.extra.office.KeyFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OfficeFile {
    private TypeAndVersionKeyFactory keyFactory = KeyFactory.createFactory(TypeAndVersionKeyFactory.class, this.getClass().getClassLoader());
    private static OfficeFile instance = new OfficeFile();
    private Map<String, Type> typeByExtension = new HashMap<String, Type>();
    private Map<String, Version> versionByExtension = new HashMap<String, Version>();
    private Map<String, Type> typeByMimeType = new HashMap<String, Type>();
    private Map<String, Version> versionByMimeType = new HashMap<String, Version>();
    private Map<Object, Set<String>> extensionsByTypeAndVersion = new HashMap<Object, Set<String>>();
    private Map<Object, Set<String>> mimeTypesByTypeAndVersion = new HashMap<Object, Set<String>>();

    private OfficeFile() {
        this.addFiles();
        this.freezeMaps();
    }

    private void freezeMaps() {
        this.typeByExtension = Collections.unmodifiableMap(this.typeByExtension);
        this.versionByExtension = Collections.unmodifiableMap(this.versionByExtension);
        this.typeByMimeType = Collections.unmodifiableMap(this.typeByMimeType);
        this.versionByMimeType = Collections.unmodifiableMap(this.versionByMimeType);
        this.freezeMultimap(this.extensionsByTypeAndVersion);
        this.freezeMultimap(this.mimeTypesByTypeAndVersion);
        this.extensionsByTypeAndVersion = Collections.unmodifiableMap(this.extensionsByTypeAndVersion);
        this.mimeTypesByTypeAndVersion = Collections.unmodifiableMap(this.mimeTypesByTypeAndVersion);
    }

    private <T> void freezeMultimap(Map<T, Set<String>> map) {
        for (T t : map.keySet()) {
            map.put(t, Collections.unmodifiableSet(map.get(t)));
        }
    }

    private static <K, V> void addTo(K key, V toAdd, Map<K, Set<V>> container) {
        Set<V> existing = container.get(key);
        if (existing == null) {
            existing = new HashSet<V>();
            container.put(key, existing);
        }
        existing.add(toAdd);
    }

    private void addFiles() {
        this.addFileByExtension(Type.Word, Version.V97, "doc", "dot");
        this.addFileByExtension(Type.Word, Version.V2007, "docx", "dotx");
        this.addFileByMimeType(Type.Word, Version.V97, "application/msword");
        this.addFileByMimeType(Type.Word, Version.V2007, "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "vnd.ms-word.document.macroEnabled.12", "vnd.ms-word.template.macroEnabled.12");
        this.addFileByExtension(Type.Excel, Version.V97, "xls", "xlt");
        this.addFileByExtension(Type.Excel, Version.V2007, "xlsx", "xlst", "xlsm");
        this.addFileByMimeType(Type.Excel, Version.V97, "application/excel", "application/x-excel", "application/x-msexcel", "application/vnd.ms-excel");
        this.addFileByMimeType(Type.Excel, Version.V2007, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "vnd.ms-excel.sheet.macroEnabled.12", "vnd.ms-excel.template.macroEnabled.12");
        this.addFileByExtension(Type.PowerPoint, Version.V97, "ppt", "pot");
        this.addFileByExtension(Type.PowerPoint, Version.V2007, "pptx", "ppsx", "potx", "pptm");
        this.addFileByMimeType(Type.PowerPoint, Version.V97, "application/powerpoint", "application/mspowerpoint", "application/x-mspowerpoint", "application/vnd.ms-powerpoint");
        this.addFileByMimeType(Type.PowerPoint, Version.V2007, "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.openxmlformats-officedocument.presentationml.template", "vnd.ms-powerpoint.template.macroEnabled.12", "vnd.ms-powerpoint.addin.macroEnabled.12", "vnd.ms-powerpoint.slideshow.macroEnabled.12", "vnd.ms-powerpoint.presentation.macroEnabled.12");
    }

    private void addFileByExtension(Type type, Version version, String ... extensions) {
        for (String extension : extensions) {
            this.typeByExtension.put(extension, type);
            this.versionByExtension.put(extension, version);
            OfficeFile.addTo(this.keyFactory.createKey(type, version), extension, this.extensionsByTypeAndVersion);
        }
    }

    private void addFileByMimeType(Type type, Version version, String ... mimeTypes) {
        for (String mimeType : mimeTypes) {
            this.typeByMimeType.put(mimeType, type);
            this.versionByMimeType.put(mimeType, version);
            OfficeFile.addTo(this.keyFactory.createKey(type, version), mimeType, this.mimeTypesByTypeAndVersion);
        }
    }

    public static boolean isOfficeExtension(String extension) {
        return OfficeFile.instance.typeByExtension.containsKey(extension);
    }

    public static boolean isOfficeMimeType(String mimeType) {
        return OfficeFile.instance.typeByMimeType.containsKey(mimeType);
    }

    public static Set<String> getExtensionsFor(Type type) {
        HashSet<String> rv = new HashSet<String>();
        for (Version version : Version.values()) {
            rv.addAll(OfficeFile.getExtensionsFor(type, version));
        }
        return rv;
    }

    public static Set<String> getExtensionsFor(Type type, Version version) {
        return OfficeFile.instance.extensionsByTypeAndVersion.get(OfficeFile.instance.keyFactory.createKey(type, version));
    }

    public static Set<String> getMimeTypesFor(Type type) {
        HashSet<String> rv = new HashSet<String>();
        for (Version version : Version.values()) {
            rv.addAll(OfficeFile.getMimeTypesFor(type, version));
        }
        return rv;
    }

    public static Set<String> getMimeTypesFor(Type type, Version version) {
        return OfficeFile.instance.mimeTypesByTypeAndVersion.get(OfficeFile.instance.keyFactory.createKey(type, version));
    }

    public static enum Version {
        V97,
        V2007;

    }

    public static enum Type {
        Word,
        Excel,
        PowerPoint;

    }

    public static interface TypeAndVersionKeyFactory {
        public Object createKey(Type var1, Version var2);
    }
}

