/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.office;

import com.atlassian.confluence.extra.office.KeyObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class KeyFactory
implements InvocationHandler {
    private static KeyFactory instance = new KeyFactory();

    public static <T> T createFactory(Class<T> factoryInterface) {
        return KeyFactory.createFactory(factoryInterface, Thread.currentThread().getContextClassLoader());
    }

    public static <T> T createFactory(Class<T> factoryInterface, ClassLoader loader) {
        return instance.createFactoryInternal(factoryInterface, loader);
    }

    private <T> T createFactoryInternal(Class<T> factoryInterface, ClassLoader loader) {
        return (T)Proxy.newProxyInstance(loader, new Class[]{factoryInterface}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (this.isCreateKey(method)) {
            return new KeyObject(args);
        }
        if (this.isToString(method)) {
            return "Generated KeyFactory";
        }
        throw new RuntimeException("You must create a public method called createKey that accepts at least one parameter");
    }

    private boolean isCreateKey(Method m) {
        return m.getName().equals("createKey") && m.getParameterTypes().length > 0;
    }

    private boolean isToString(Method m) {
        return m.getName().equals("toString") && m.getParameterTypes().length == 0;
    }
}

