/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.imageeffects.client;

import com.atlassian.imageeffects.client.ConnectionDetails;
import com.atlassian.imageeffects.client.HttpClientImageEffectsClient;
import com.atlassian.imageeffects.client.ImageEffectsClient;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageEffectsClientFactory {
    private static final Logger log = LoggerFactory.getLogger(ImageEffectsClientFactory.class);

    public static ImageEffectsClient create(ConnectionDetails connectionDetails, Iterable<HttpRequestInterceptor> requestInterceptors, Iterable<HttpResponseInterceptor> responseInterceptors) {
        HttpClientBuilder builder = HttpClients.custom();
        requestInterceptors.forEach(arg_0 -> ((HttpClientBuilder)builder).addInterceptorFirst(arg_0));
        responseInterceptors.forEach(arg_0 -> ((HttpClientBuilder)builder).addInterceptorFirst(arg_0));
        builder.setConnectionManager(ImageEffectsClientFactory.createClientConnectionManager(connectionDetails)).setDefaultRequestConfig(ImageEffectsClientFactory.createRequestConfig(connectionDetails));
        return new HttpClientImageEffectsClient(builder.build(), connectionDetails);
    }

    public static ImageEffectsClient create(ConnectionDetails connectionDetails, Iterable<HttpRequestInterceptor> interceptors) {
        return ImageEffectsClientFactory.create(connectionDetails, interceptors, Collections.emptyList());
    }

    public static ImageEffectsClient create(ConnectionDetails connectionDetails) {
        return ImageEffectsClientFactory.create(connectionDetails, Collections.emptyList());
    }

    private static RequestConfig createRequestConfig(ConnectionDetails connectionDetails) {
        return RequestConfig.custom().setCookieSpec("ignoreCookies").setConnectTimeout(connectionDetails.getConnectTimeout()).setSocketTimeout(connectionDetails.getSocketTimeout()).build();
    }

    private static HttpClientConnectionManager createClientConnectionManager(ConnectionDetails connectionDetails) {
        PoolingHttpClientConnectionManager result;
        if (connectionDetails.isTrustSelfSignedCerts()) {
            log.info("Installing ability to trust self-signed certificates");
            result = new PoolingHttpClientConnectionManager(ImageEffectsClientFactory.createSocketFactoryRegistry(), null, null, null, (long)connectionDetails.getConnectionTimeToLive(), TimeUnit.MILLISECONDS);
        } else {
            result = new PoolingHttpClientConnectionManager((long)connectionDetails.getConnectionTimeToLive(), TimeUnit.MILLISECONDS);
        }
        result.setMaxTotal(connectionDetails.getMaxConnections());
        return result;
    }

    private static Registry<ConnectionSocketFactory> createSocketFactoryRegistry() {
        SSLContext sslContext;
        SSLContextBuilder builder = SSLContexts.custom();
        try {
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            sslContext = builder.build();
        }
        catch (Exception ex) {
            log.warn("Unable to create SSLContext", (Throwable)ex);
            throw new IllegalStateException("Unable to create SSLContext", ex);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        return RegistryBuilder.create().register("https", (Object)sslsf).build();
    }
}

