/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.imageeffects.client;

import com.atlassian.fugue.Either;
import com.atlassian.imageeffects.client.ConnectionDetails;
import com.atlassian.imageeffects.client.Failure;
import com.atlassian.imageeffects.client.ImageEffectsClient;
import com.atlassian.imageeffects.client.InputStreamConsumer;
import com.atlassian.imageeffects.client.Success;
import com.atlassian.imageeffects.client.TransformResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

class HttpClientImageEffectsClient
implements ImageEffectsClient {
    private final CloseableHttpClient client;
    private final ConnectionDetails connectionDetails;

    HttpClientImageEffectsClient(CloseableHttpClient client, ConnectionDetails connectionDetails) {
        this.client = client;
        this.connectionDetails = connectionDetails;
    }

    @Override
    @Nonnull
    public <R> Either<Failure, Success<R>> transform(@WillNotClose InputStream image, String[] effects, String label, InputStreamConsumer<R> consumer) {
        HttpPost postie = this.buildHttpPost(image, effects, label);
        try {
            return (Either)this.client.execute((HttpUriRequest)postie, new TransformResponseHandler<R>(consumer));
        }
        catch (IOException e) {
            return Either.left((Object)new Failure(Failure.Reason.IO_EXCEPTION, e));
        }
    }

    private HttpPost buildHttpPost(InputStream image, String[] effects, String label) {
        HttpEntity reqEntity = MultipartEntityBuilder.create().addTextBody("effects", this.buildEffectsString(effects)).addTextBody("label", label).addBinaryBody("data", image, ContentType.MULTIPART_FORM_DATA, "image").build();
        HttpPost postie = new HttpPost(this.buildUri());
        postie.setEntity(reqEntity);
        return postie;
    }

    private String buildEffectsString(String[] effects) {
        if (effects.length == 0) {
            return "";
        }
        if (effects.length == 1) {
            return effects[0].trim();
        }
        StringBuilder sb = new StringBuilder(effects[0].trim());
        for (int i = 1; i < effects.length; ++i) {
            sb.append(',').append(effects[i].trim());
        }
        return sb.toString();
    }

    private URI buildUri() {
        return this.connectionDetails.getServiceUri().resolve("/transform");
    }

    CloseableHttpClient getClient() {
        return this.client;
    }
}

