/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.image.effects;

import com.atlassian.confluence.pages.persistence.dao.filesystem.HierarchicalContentFileSystemHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCache {
    private static final Logger log = LoggerFactory.getLogger(ImageCache.class);
    private HierarchicalContentFileSystemHelper fileSystemHelper = new HierarchicalContentFileSystemHelper();
    File cacheDir;

    public ImageCache(String path) throws IOException {
        this.cacheDir = new File(path);
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            throw new IOException("The specified path: " + path + " doesn't exist and we are unable to create it.");
        }
        if (!this.cacheDir.canRead() || !this.cacheDir.canWrite()) {
            throw new IOException("Confluence doesn't have read/write access to the specified cache directory:" + path + ".");
        }
    }

    public InputStream get(String name, long modified) {
        return this.get(Optional.empty(), name, modified);
    }

    public InputStream get(Optional<Long> attachmentId, String name, long modified) {
        File imageFolder;
        File file = imageFolder = attachmentId.isPresent() ? this.fileSystemHelper.getDirectory(this.cacheDir, attachmentId.get().longValue()) : this.cacheDir;
        if (!imageFolder.exists()) {
            return null;
        }
        File child = new File(imageFolder, name + ".png").getAbsoluteFile();
        FileInputStream in = null;
        if (child.exists() && child.canRead() && child.lastModified() >= modified) {
            try {
                in = new FileInputStream(child);
            }
            catch (Exception e) {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException ioe) {
                    log.warn("could not close input file", (Throwable)ioe);
                }
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Optional<Long> attachmentId, String name, byte[] val) {
        File imageFolder = this.getImageFolder(attachmentId);
        File file = new File(imageFolder, name + ".png").getAbsoluteFile();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ((OutputStream)out).write(val, 0, val.length);
        }
        catch (Exception ioe) {
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ioe) {
                log.warn("could not close output file", (Throwable)ioe);
            }
        }
    }

    private File getImageFolder(Optional<Long> attachmentId) {
        File imageFolder = this.cacheDir;
        if (attachmentId.isPresent() && !(imageFolder = this.fileSystemHelper.getDirectory(this.cacheDir, attachmentId.get().longValue())).exists()) {
            imageFolder = this.fileSystemHelper.createDirectoryHierarchy(this.cacheDir, attachmentId.get().longValue());
        }
        return imageFolder;
    }

    public void clearPreviews() {
        File[] previews;
        for (File file : previews = this.cacheDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("preview");
            }
        })) {
            file.delete();
        }
    }
}

