/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.image.effects;

import com.atlassian.confluence.image.effects.ImageEffectsConfig;
import com.atlassian.confluence.image.effects.ImageEffectsConfigChangedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/config")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
public class ConfigResource {
    private static final Logger log = LoggerFactory.getLogger(ConfigResource.class);
    private final ImageEffectsConfig config;
    private final EventPublisher eventPublisher;

    public ConfigResource(ImageEffectsConfig config, EventPublisher eventPublisher) {
        this.config = Objects.requireNonNull(config);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    @GET
    @Produces(value={"application/json"})
    public Map<String, String> getConfig() {
        return this.mapOfConfig();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Map<String, String> postConfig(@FormParam(value="disable_cache") Boolean disableCache, @FormParam(value="transform.timeout_ms") String transformTimeoutMs, @FormParam(value="transform.max_data_size") String transformMaxDataSize, @FormParam(value="client.url") String clientUrl, @FormParam(value="client.trust_self_signed_certs") Boolean clientTrustSelfies, @FormParam(value="client.connect_timeout_ms") String clientConnectTimeoutMs, @FormParam(value="client.connection_ttl_ms") String clientConnectionTtlMs, @FormParam(value="client.socket_timeout_ms") String clientSocketTimeoutMs) {
        Integer value;
        boolean configChanged = false;
        if (disableCache != null) {
            this.config.setDisableCache(disableCache);
            configChanged = true;
        }
        if ((value = this.parseInteger("transform.timeout_ms", transformTimeoutMs)) != null) {
            this.config.setTransformTimeoutMs(value);
            configChanged = true;
        }
        if ((value = this.parseInteger("transform.max_data_size", transformMaxDataSize)) != null) {
            this.config.setTransformMaxDataSize(value);
            configChanged = true;
        }
        if (clientUrl != null) {
            this.config.setClientUrl(clientUrl.trim().length() > 0 ? clientUrl : null);
            configChanged = true;
        }
        if (clientTrustSelfies != null) {
            this.config.setClientTrustSelfies(clientTrustSelfies);
            configChanged = true;
        }
        if ((value = this.parseInteger("client.connect_timeout_ms", clientConnectTimeoutMs)) != null) {
            this.config.setClientConnectTimeoutMs(value);
            configChanged = true;
        }
        if ((value = this.parseInteger("client.connection_ttl_ms", clientConnectionTtlMs)) != null) {
            this.config.setClientConnectionTtlMs(value);
            configChanged = true;
        }
        if ((value = this.parseInteger("client.socket_timeout_ms", clientSocketTimeoutMs)) != null) {
            this.config.setClientSocketTimeoutMs(value);
            configChanged = true;
        }
        if (configChanged) {
            log.info("Configuration has changed, sending an event");
            this.eventPublisher.publish((Object)new ImageEffectsConfigChangedEvent());
        }
        return this.mapOfConfig();
    }

    @Nullable
    private Integer parseInteger(String name, String strVal) {
        if (strVal == null) {
            return null;
        }
        try {
            return Integer.parseInt(strVal);
        }
        catch (NumberFormatException e) {
            log.info("Unable to parse parameter '{}' with value '{}'", (Object)name, (Object)strVal);
            return null;
        }
    }

    private Map<String, String> mapOfConfig() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("thread_pool_configuration.core_pool_size", Integer.toString(this.config.getCorePoolSize()));
        result.put("thread_pool_configuration.max_pool_size", Integer.toString(this.config.getMaximumPoolSize()));
        result.put("thread_pool_configuration.queue_size", Integer.toString(this.config.getQueueSize()));
        result.put("thread_pool_configuration.keep_alive_time", Long.toString(this.config.getKeepAliveTime()));
        result.put("thread_pool_configuration.time_unit", this.config.getTimeUnit().name());
        result.put("disable_cache", Boolean.toString(this.config.isDisableCache()));
        result.put("transform.timeout_ms", Integer.toString(this.config.getTransformTimeoutMs()));
        result.put("transform.max_data_size", Integer.toString(this.config.getTransformMaxDataSize()));
        result.put("client.url", this.config.getClientUrl());
        result.put("client.trust_self_signed_certs", Boolean.toString(this.config.isClientTrustSelfies()));
        result.put("client.connect_timeout_ms", Integer.toString(this.config.getClientConnectTimeoutMs()));
        result.put("client.connection_ttl_ms", Integer.toString(this.config.getClientConnectionTtlMs()));
        result.put("client.socket_timeout_ms", Integer.toString(this.config.getClientSocketTimeoutMs()));
        return result;
    }
}

