/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.query;

import com.atlassian.confluence.ext.usage.UsagePeriod;
import java.util.Date;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class UsageDataUtils {
    public static RegularTimePeriod getTimePeriod(String periodName, Date date) {
        return RegularTimePeriod.createInstance(UsageDataUtils.getTimePeriodClass(periodName), date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public static Class getTimePeriodClass(String periodName) {
        return UsagePeriod.resolve(periodName).getType();
    }

    public static TimeSeriesCollection makeCumulative(TimeSeriesCollection collection) {
        TimeSeriesCollection result = new TimeSeriesCollection();
        for (int i = 0; i < collection.getSeriesCount(); ++i) {
            TimeSeries oldSeries = collection.getSeries(i);
            TimeSeries cumulativeSeries = new TimeSeries(oldSeries.getKey(), oldSeries.getTimePeriodClass());
            int cumulativeValue = 0;
            for (int j = 0; j < oldSeries.getItemCount(); ++j) {
                cumulativeSeries.add(oldSeries.getTimePeriod(j), (Number)(cumulativeValue += oldSeries.getValue(j).intValue()));
            }
            result.addSeries(cumulativeSeries);
        }
        return result;
    }

    public static void normaliseDateRange(TimeSeriesCollection collection, RegularTimePeriod[] range) {
        if (collection.getSeriesCount() == 0) {
            return;
        }
        RegularTimePeriod earliest = range[0];
        RegularTimePeriod latest = range[1];
        RegularTimePeriod cursor = earliest;
        for (int i = 0; i < collection.getSeriesCount(); ++i) {
            TimeSeries series = collection.getSeries(i);
            while (cursor.compareTo(latest) != 1) {
                if (series.getValue(cursor) == null) {
                    series.add(cursor, (Number)0);
                }
                cursor = cursor.next();
            }
            cursor = earliest;
        }
    }
}

