/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.macros;

import com.atlassian.bonnie.LuceneException;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.ext.usage.index.UsageIndexManager;
import com.atlassian.confluence.ext.usage.macros.AbstractUsageMacro;
import com.atlassian.confluence.ext.usage.query.ContentUsageQuery;
import com.atlassian.confluence.ext.usage.query.UsageDataUtils;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.v2.RenderUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageStatsMacro
extends AbstractUsageMacro {
    private static final Logger log = LoggerFactory.getLogger(UsageStatsMacro.class);

    public UsageStatsMacro(UsageIndexManager usageIndexManager, @ComponentImport LabelManager labelManager, @ComponentImport SpaceManager spaceManager) {
        super(usageIndexManager, labelManager, spaceManager);
    }

    @Override
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) {
        String period = this.calculatePeriod(parameters);
        Collection<Space> spaces = this.calculateSpaces(parameters, conversionContext);
        Collection<String> contentTypes = this.calculateTypes(parameters);
        Collection<String> eventTypes = this.calculateEvents(parameters);
        String columns = this.calculateColumns(parameters);
        Date[] timespan = this.calculateTimeSpan(parameters);
        ContentUsageQuery query = new ContentUsageQuery();
        query.setPeriod(period);
        query.setSpaces(spaces);
        query.setContentTypes(contentTypes);
        query.setEventTypes(eventTypes);
        query.setColumns(columns);
        if (timespan != null) {
            query.setTimespan(timespan);
        }
        try {
            TimeSeriesCollection dataset = this.usageIndexManager.queryUsage(query);
            if (parameters.containsKey("cumulative") && "true".equalsIgnoreCase(parameters.get("cumulative"))) {
                dataset = UsageDataUtils.makeCumulative(dataset);
            }
            if (parameters.containsKey("forchart") && "true".equalsIgnoreCase(parameters.get("forchart"))) {
                this.normaliseForChart(dataset, query, timespan);
            }
            Map<String, Object> velocityContext = this.getDefaultMacroVelocityContext();
            velocityContext.put("macro", (Object)this);
            velocityContext.put("period", period);
            velocityContext.put("spaces", spaces);
            velocityContext.put("contentTypes", contentTypes);
            velocityContext.put("eventTypes", eventTypes);
            velocityContext.put("debug", Boolean.toString("true".equals(parameters.get("debug"))));
            if (timespan != null) {
                velocityContext.put("afterTime", timespan[0]);
                velocityContext.put("beforeTime", timespan[1]);
            }
            velocityContext.put("usageQuery", query);
            velocityContext.put("dataset", dataset);
            return this.renderUsageStats(velocityContext);
        }
        catch (LuceneException e) {
            if (log.isErrorEnabled()) {
                log.error("Error querying for data.", (Throwable)e);
            }
            if (e.getCause() instanceof IOException) {
                return RenderUtils.blockError((String)"Error in reading index files to generate usage statistics. Please try rebuilding the index.", (String)"");
            }
            return RenderUtils.blockError((String)("Error querying popular content usage: " + (Object)((Object)e)), (String)"");
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Unable to render macro.", (Throwable)e);
            }
            return RenderUtils.blockError((String)("Error in macro: " + e), (String)"");
        }
    }

    Map<String, Object> getDefaultMacroVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }

    protected String renderUsageStats(Map velocityContext) {
        return VelocityUtils.getRenderedTemplate((String)"/templates/usage/usage-stats.vm", (Map)velocityContext);
    }

    private void normaliseForChart(TimeSeriesCollection collection, ContentUsageQuery q, Date[] timespan) {
        RegularTimePeriod start = UsageDataUtils.getTimePeriod(q.getPeriod(), timespan[0]);
        RegularTimePeriod end = UsageDataUtils.getTimePeriod(q.getPeriod(), timespan[1]).previous();
        UsageDataUtils.normaliseDateRange(collection, new RegularTimePeriod[]{start, end});
    }
}

