/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.macros;

import com.atlassian.bonnie.LuceneException;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.ext.usage.index.PopularResult;
import com.atlassian.confluence.ext.usage.index.UsageIndexManager;
import com.atlassian.confluence.ext.usage.macros.AbstractUsageMacro;
import com.atlassian.confluence.ext.usage.query.ContentUsageQuery;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.v2.RenderUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopularMacro
extends AbstractUsageMacro {
    private static final Logger log = LoggerFactory.getLogger(PopularMacro.class);

    public PopularMacro(UsageIndexManager usageIndexManager, @ComponentImport LabelManager labelManager, @ComponentImport SpaceManager spaceManager) {
        super(usageIndexManager, labelManager, spaceManager);
    }

    @Override
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) {
        Collection<Space> spaces = this.calculateSpaces(parameters, conversionContext);
        Collection<String> contentTypes = this.calculateTypes(parameters);
        Collection<Label> labels = this.calculateLabels(parameters, conversionContext);
        Collection display = this.getDelimitedStringParameter("display", parameters, EasyList.build((Object)"title", (Object)"count"));
        Date[] timespan = this.calculateTimeSpan(parameters, "1w");
        Collection<String> eventTypes = this.calculateEvents(parameters);
        int max = this.getIntParameter("max", parameters, 10);
        String style = this.getStringParameter("style", parameters, "table");
        ContentUsageQuery query = new ContentUsageQuery();
        query.setSpaces(spaces);
        query.setLabels(labels);
        query.setContentTypes(contentTypes);
        query.setEventTypes(eventTypes);
        if (timespan != null) {
            query.setTimespan(timespan);
        }
        try {
            List<PopularResult> popular = this.usageIndexManager.queryPopular(query, max);
            Map<String, Object> velocityContext = this.getDefaultMacroVelocityContext();
            velocityContext.put("macro", (Object)this);
            velocityContext.put("spaces", spaces);
            velocityContext.put("contentTypes", contentTypes);
            velocityContext.put("eventTypes", eventTypes);
            velocityContext.put("labels", labels);
            velocityContext.put("debug", Boolean.toString("true".equals(parameters.get("debug"))));
            if (timespan != null) {
                velocityContext.put("afterTime", timespan[0]);
                velocityContext.put("beforeTime", timespan[1]);
            }
            velocityContext.put("usageQuery", query);
            velocityContext.put("popular", popular);
            velocityContext.put("max", max);
            velocityContext.put("style", style);
            velocityContext.put("display", display);
            return this.renderPopular(velocityContext);
        }
        catch (LuceneException e) {
            if (log.isErrorEnabled()) {
                log.error("Error querying for data.", (Throwable)e);
            }
            if (e.getCause() instanceof IOException) {
                return RenderUtils.blockError((String)"Error in reading index files to query popular content usage. Please try rebuilding the index.", (String)"");
            }
            return RenderUtils.blockError((String)("Error querying popular content usage: " + (Object)((Object)e)), (String)"");
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Unable to render macro.", (Throwable)e);
            }
            return RenderUtils.blockError((String)("Error in macro: " + e), (String)"");
        }
    }

    Map<String, Object> getDefaultMacroVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }

    protected String renderPopular(Map velocityContext) {
        return VelocityUtils.getRenderedTemplate((String)"/templates/usage/popular.vm", (Map)velocityContext);
    }
}

