/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.conditions;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackwardsCompatibilitySpaceSideBarCondition
extends BaseConfluenceCondition {
    private static final Logger LOG = LoggerFactory.getLogger(BackwardsCompatibilitySpaceSideBarCondition.class);
    private static final String SIDEBAR_PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-space-ia";
    private final PluginAccessor pluginAccessor;
    private final ThemeManager themeManager;

    public BackwardsCompatibilitySpaceSideBarCondition(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport ThemeManager themeManager) {
        this.pluginAccessor = pluginAccessor;
        this.themeManager = themeManager;
    }

    protected boolean shouldDisplay(WebInterfaceContext webInterfaceContext) {
        Space space = webInterfaceContext.getSpace();
        boolean pluginEnabled = this.pluginAccessor.isPluginEnabled(SIDEBAR_PLUGIN_KEY);
        boolean correctSpaceTheme = space != null && this.hasSpaceSideBar(space);
        return correctSpaceTheme && pluginEnabled;
    }

    private boolean hasSpaceSideBar(Space space) {
        Theme spaceTheme = this.themeManager.getSpaceTheme(space.getKey());
        try {
            Method hasSpaceSideBarMethod = spaceTheme.getClass().getMethod("hasSpaceSideBar", new Class[0]);
            return (Boolean)hasSpaceSideBarMethod.invoke((Object)spaceTheme, new Object[0]);
        }
        catch (NoSuchMethodException noHasSideBarMethod) {
            LOG.debug("Theme object does not have hasSideBar() method. Assuming we dont't have Space IA.", (Throwable)noHasSideBarMethod);
        }
        catch (IllegalAccessException hasSideBarMethodNotVisible) {
            LOG.error("Theme.hasSideBar() cannot be called.", (Throwable)hasSideBarMethodNotVisible);
        }
        catch (InvocationTargetException hasSideBarMethodFubared) {
            LOG.error("Theme.hasSideBar() failed.", (Throwable)hasSideBarMethodFubared);
        }
        return false;
    }
}

