package com.atlassian.confluence.ext.usage.index;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.ext.usage.UsageConstants;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;

import java.util.Collection;

public class PopularResult implements Comparable<PopularResult> {
    private String entityId;
    private String entityType;
    private int count;
    private Space space;
    private SpaceManager spaceManager;
    private ContentEntityManager contentEntityManager;
    private ContentEntityObject ceo;
    private Collection<Label> labels;

    public PopularResult(SpaceManager spaceManager, ContentEntityManager contentEntityManager, String entityId, String entityType) {
        this.contentEntityManager = contentEntityManager;
        this.spaceManager = spaceManager;
        this.entityId = entityId;
        this.entityType = entityType;
        count = 0;
    }

    public boolean isSpace() {
        return entityType.equals(UsageConstants.SPACE_ENTITY_TYPE);
    }

    public boolean isPage() {
        return entityType.equals(Page.CONTENT_TYPE);
    }

    public boolean isComment() {
        return entityType.equals(Comment.CONTENT_TYPE);
    }

    public boolean isBlogPost() {
        return entityType.equals(BlogPost.CONTENT_TYPE);
    }

    public Space getSpace() {
        if (isSpace() && space == null && entityId != null)
            space = spaceManager.getSpace(Long.parseLong(entityId));

        return space;
    }

    public ContentEntityObject getContent() {
        if (isContent() && ceo == null && entityId != null)
            ceo = contentEntityManager.getById(Long.parseLong(entityId));

        return ceo;
    }

    public Collection<Label> getLabels() {
        if (isContent())
            labels = getContent().getLabels();

        return labels;
    }

    public boolean isContent() {
        return isPage() || isComment() || isBlogPost();
    }

    public String getEntityId() {
        return entityId;
    }

    public String getEntityType() {
        return entityType;
    }

    public int getCount() {
        return count;
    }

    public void incrementCount() {
        count++;
    }

    public int compareTo(PopularResult popularResult) {
        if (popularResult.count > count)
            return 1;
        else if (popularResult.count < count)
            return -1;
        return 0;
    }

    public String toString() {
        return entityType + ":" + entityId + "(" + count + ")";
    }
}
