package com.atlassian.confluence.ext.usage.cluster;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * This Spring bean will throw an exception if instantiated in a clustered environment
 */
@Component
public class UnclusteredOnlySpringBean implements InitializingBean {

    private final ClusterManager clusterManager;

    @Autowired
    public UnclusteredOnlySpringBean(@ComponentImport final ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    @Override
    public void afterPropertiesSet() {
        if (clusterManager.isClustered()) {
            throw new RuntimeException("This plugin cannot be used in a cluster.");
        }
    }
}
