package com.atlassian.confluence.ext.usage.actions;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAware;

/**
 * Action class for the space usage report
 */
public class SpaceUsageReport extends AbstractUsageReport implements SpaceAware {
    private Space space;

    public void setSpace(Space space) {
        this.space = space;
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public Space getSpace() {
        return space;
    }

    public String getSpaceKey() {
        return space.getKey();
    }
}
