package com.atlassian.confluence.ext.usage.actions;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;

/**
 * Action class for the global usage report
 */
public class GlobalUsageReport extends AbstractUsageReport {

    @Override
    public boolean isPermitted() {
        return super.isPermitted()
                && permissionManager.hasPermission(getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }
}
