/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.msnftp;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.sf.cindy.Message;
import net.sf.cindy.MessageRecognizer;
import net.sf.cindy.Session;
import net.sf.cindy.util.ByteBufferUtils;
import net.sf.jml.MsnFileTransfer;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnProtocol;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.protocol.MsnMessage;
import net.sf.jml.protocol.WrapperMessage;
import net.sf.jml.protocol.msnftp.MsnftpBYE;
import net.sf.jml.protocol.msnftp.MsnftpCCL;
import net.sf.jml.protocol.msnftp.MsnftpContent;
import net.sf.jml.protocol.msnftp.MsnftpFIL;
import net.sf.jml.protocol.msnftp.MsnftpMessage;
import net.sf.jml.protocol.msnftp.MsnftpTFR;
import net.sf.jml.protocol.msnftp.MsnftpUSR;
import net.sf.jml.protocol.msnftp.MsnftpVER;
import net.sf.jml.util.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MsnftpMessageRecognizer
implements MessageRecognizer {
    private static final ByteBuffer SPLIT = Charset.encode("\r\n");
    private static final Map<String, Class<? extends MsnftpMessage>> mappingMap = new HashMap<String, Class<? extends MsnftpMessage>>();
    private static MsnftpMessageRecognizer instance;

    public static MsnftpMessageRecognizer getInstance() {
        return instance;
    }

    private MsnftpMessageRecognizer() {
    }

    @Override
    public Message recognize(Session session, ByteBuffer byteBuffer) {
        MsnMessage msnMessage;
        if (ByteBufferUtils.indexOf(byteBuffer, SPLIT) < 0) {
            return null;
        }
        if (byteBuffer.remaining() < 3) {
            return null;
        }
        MsnMessenger msnMessenger = ((MsnFileTransfer)session.getAttachment()).getMessenger();
        byte by = byteBuffer.get(byteBuffer.position());
        if (by == 0 || by == 1) {
            msnMessage = new MsnftpContent(msnMessenger.getActualMsnProtocol());
        } else {
            String string = Charset.decode((ByteBuffer)byteBuffer.limit(byteBuffer.position() + 3));
            Class<? extends MsnftpMessage> clazz = mappingMap.get(string);
            if (clazz == null) {
                session.close(false);
                return null;
            }
            msnMessage = this.getMessageInstance(clazz, msnMessenger);
        }
        return new WrapperMessage(msnMessage);
    }

    private MsnMessage getMessageInstance(Class<? extends MsnftpMessage> clazz, MsnMessenger msnMessenger) {
        try {
            return clazz.getConstructor(MsnProtocol.class).newInstance(msnMessenger.getActualMsnProtocol());
        }
        catch (Exception exception) {
            ((AbstractMessenger)msnMessenger).fireExceptionCaught(exception);
            return null;
        }
    }

    static {
        mappingMap.put("VER", MsnftpVER.class);
        mappingMap.put("USR", MsnftpUSR.class);
        mappingMap.put("FIL", MsnftpFIL.class);
        mappingMap.put("CCL", MsnftpCCL.class);
        mappingMap.put("BYE", MsnftpBYE.class);
        mappingMap.put("TFR", MsnftpTFR.class);
        instance = new MsnftpMessageRecognizer();
    }
}

