/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.cindy.util.ByteBufferUtils;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnProtocol;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.message.p2p.DisplayPictureDuel;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingMSG;
import net.sf.jml.util.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MsnP2PMessage
extends MsnMimeMessage {
    private static final Log log = LogFactory.getLog(MsnSession.class);
    protected static final String KEY_P2P_DEST = "P2P-Dest";
    protected static final int BINARY_HEADER_LEN = 48;
    private final ByteBuffer binaryHeader = ByteBuffer.allocate(48).order(ByteOrder.LITTLE_ENDIAN);
    protected static final int FLAG_NONE = 0;
    protected static final int FLAG_ACK = 2;
    protected static final int FLAG_BYE_ACK = 64;
    protected static final int FLAG_DATA = 32;
    protected static final int FLAG_BYE = 128;
    protected static final int BINARY_FOOTER_LEN = 4;
    private final ByteBuffer binaryFooter = ByteBuffer.allocate(4);

    public MsnP2PMessage() {
        this.setContentType("application/x-msnmsgrp2p");
    }

    protected void parseMessage(byte[] byArray) {
        ByteBuffer byteBuffer = Charset.encode("\r\n\r\n");
        int n = ByteBufferUtils.indexOf(ByteBuffer.wrap(byArray), byteBuffer);
        String string = n == -1 ? Charset.decode(byArray) : Charset.decode(byArray, 0, n);
        this.headers.parseString(string);
        this.binaryHeader.put(byArray, n += byteBuffer.remaining(), 48);
        this.binaryHeader.flip();
        this.parseP2PBody(ByteBuffer.wrap(byArray, n += 48, byArray.length - n - 4));
        this.binaryFooter.put(byArray, byArray.length - 4, 4);
        this.binaryFooter.flip();
    }

    public OutgoingMSG[] toOutgoingMsg(MsnProtocol msnProtocol) {
        OutgoingMSG outgoingMSG = new OutgoingMSG(msnProtocol);
        outgoingMSG.setMsgType(OutgoingMSG.TYPE_MSNC1);
        byte[] byArray = Charset.encodeAsByteArray(this.toString());
        byte[] byArray2 = this.bodyToMessage();
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 48 + byArray2.length + 4);
        byteBuffer.put(byArray);
        byteBuffer.put(this.binaryHeader);
        byteBuffer.put(byArray2);
        byteBuffer.put(this.binaryFooter);
        outgoingMSG.setMsg(byteBuffer.array());
        return new OutgoingMSG[]{outgoingMSG};
    }

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
        DisplayPictureDuel displayPictureDuel = msnSession.getMessenger().getDisplayPictureDuelManager().get(this.getField7());
        if (displayPictureDuel != null) {
            displayPictureDuel.process(this, msnContact);
        } else {
            ((AbstractMessenger)msnSession.getMessenger()).fireP2PMessageReceived(msnSession.getSwitchboard(), this, msnContact);
        }
    }

    protected abstract void parseP2PBody(ByteBuffer var1);

    protected abstract byte[] bodyToMessage();

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString());
        stringBuffer.append("===================\n");
        stringBuffer.append("=  Binary Headers =\n");
        stringBuffer.append("===================\n");
        stringBuffer.append("SessionID: ").append(this.getSessionId()).append('\n');
        stringBuffer.append("Identifier: ").append(this.getIdentifier()).append(" (").append(this.toHex(this.getIdentifier())).append(")\n");
        stringBuffer.append("Data Offset: ").append(this.getOffset()).append('\n');
        stringBuffer.append("Data Total Size: ").append(this.getTotalLength()).append('\n');
        stringBuffer.append("Message Length: ").append(this.getCurrentLength()).append('\n');
        stringBuffer.append("Flag: ").append(this.toHex(this.getFlag())).append('\n');
        stringBuffer.append("Ack Identifier: ").append(this.getField7()).append(" (").append(this.toHex(this.getField7())).append(")\n");
        stringBuffer.append("Ack Unique  ID: ").append(this.getField8()).append(" (").append(this.toHex(this.getField8())).append(")\n");
        stringBuffer.append("Ack Data  Size: ").append(this.getField9()).append('\n');
        stringBuffer.append("===================\n");
        stringBuffer.append("=       Body      =\n");
        stringBuffer.append("===================\n");
        stringBuffer.append(this.toDebugBody());
        stringBuffer.append("===================\n");
        stringBuffer.append("=  Binary Footer  =\n");
        stringBuffer.append("===================\n");
        stringBuffer.append("AppID: ").append(this.getAppId()).append('\n');
        return stringBuffer.toString();
    }

    private String toHex(long l) {
        return "0x" + BigInteger.valueOf(l).toString(16);
    }

    protected String toDebugBody() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.bodyToMessage();
        if (byArray == null) {
            return "";
        }
        stringBuffer.append(Charset.decode(byArray));
        return stringBuffer.toString();
    }

    public String getP2PDest() {
        return this.headers.getProperty(KEY_P2P_DEST);
    }

    public void setP2PDest(String string) {
        this.headers.setProperty(KEY_P2P_DEST, string);
    }

    public int getSessionId() {
        return this.binaryHeader.getInt(0);
    }

    public void setSessionId(int n) {
        this.binaryHeader.putInt(0, n);
    }

    public int getIdentifier() {
        return this.binaryHeader.getInt(4);
    }

    public void setIdentifier(int n) {
        this.binaryHeader.putInt(4, n);
    }

    public long getOffset() {
        return this.binaryHeader.getLong(8);
    }

    public void setOffset(long l) {
        this.binaryHeader.putLong(8, l);
    }

    public long getTotalLength() {
        return this.binaryHeader.getLong(16);
    }

    public void setTotalLength(long l) {
        this.binaryHeader.putLong(16, l);
    }

    public int getCurrentLength() {
        return this.binaryHeader.getInt(24);
    }

    public void setCurrentLength(int n) {
        this.binaryHeader.putInt(24, n);
    }

    public int getFlag() {
        return this.binaryHeader.getInt(28);
    }

    public void setFlag(int n) {
        this.binaryHeader.putInt(28, n);
    }

    public int getField7() {
        return this.binaryHeader.getInt(32);
    }

    public void setField7(int n) {
        this.binaryHeader.putInt(32, n);
    }

    public int getField8() {
        return this.binaryHeader.getInt(36);
    }

    public void setField8(int n) {
        this.binaryHeader.putInt(36, n);
    }

    public long getField9() {
        return this.binaryHeader.getLong(40);
    }

    public void setField9(long l) {
        this.binaryHeader.putLong(40, l);
    }

    public int getAppId() {
        return this.binaryFooter.getInt(0);
    }

    public void setAppId(int n) {
        this.binaryFooter.putInt(0, n);
    }
}

