/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.sandbox;

import com.atlassian.confluence.extra.flyingpdf.html.DecorationPolicy;
import com.atlassian.confluence.extra.flyingpdf.sandbox.SandboxPdfJoinRequest;
import com.atlassian.confluence.extra.flyingpdf.sandbox.SandboxPdfJoinResponse;
import com.atlassian.confluence.extra.flyingpdf.util.BookmarksPageProcessor;
import com.atlassian.confluence.extra.flyingpdf.util.PageNumbersPageProcessor;
import com.atlassian.confluence.extra.flyingpdf.util.PdfJoiner;
import com.atlassian.confluence.extra.flyingpdf.util.PdfPageProcessor;
import com.atlassian.confluence.extra.flyingpdf.util.PdfPostProcessor;
import com.atlassian.confluence.extra.flyingpdf.util.PdfUtils;
import com.atlassian.confluence.util.sandbox.SandboxSerializer;
import com.atlassian.confluence.util.sandbox.SandboxTask;
import com.atlassian.confluence.util.sandbox.SandboxTaskContext;
import com.google.common.collect.Lists;
import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class SandboxPdfJoinTask
implements SandboxTask<SandboxPdfJoinRequest, SandboxPdfJoinResponse> {
    public SandboxPdfJoinResponse apply(SandboxTaskContext context, SandboxPdfJoinRequest request) {
        String intermediateFile = request.getOutputFile() + "-partial";
        try {
            new PdfJoiner(intermediateFile, request.getExportedSpaceStructure()).join();
            ArrayList pageProcessors = Lists.newArrayList((Object[])new PdfPageProcessor[]{new BookmarksPageProcessor(request.getSpaceKey(), request.getExportedSpaceStructure().locationByTitleMap(), request.getBaseUrl())});
            if (request.getDecorationPolicy().components().contains((Object)DecorationPolicy.DecorationComponent.PAGE_NUMBERS)) {
                pageProcessors.add(new PageNumbersPageProcessor());
            }
            new PdfPostProcessor(intermediateFile, request.getOutputFile(), pageProcessors).run();
        }
        catch (DocumentException | IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            new File(intermediateFile).delete();
        }
        File outputFile = new File(request.getOutputFile());
        return new SandboxPdfJoinResponse(outputFile, PdfUtils.numberOfPages(outputFile));
    }

    public SandboxSerializer<SandboxPdfJoinRequest> inputSerializer() {
        return SandboxPdfJoinRequest.serializer();
    }

    public SandboxSerializer<SandboxPdfJoinResponse> outputSerializer() {
        return SandboxPdfJoinResponse.serializer();
    }
}

