package com.atlassian.confluence.extra.flyingpdf.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * This is a single Confluence page with generated PDF file. The class is used for various post processing, where
 * from multiple PDF files for each page we eventually come with single merged space PDF.
 */
public class PdfNode implements Serializable {

    private final String pageTitle;

    private final RenderedPdfFile renderedPdfFile;

    private final List<PdfNode> children = new ArrayList<>();

    public PdfNode(String pageTitle, RenderedPdfFile renderedPdfFile) {
        this.pageTitle = pageTitle;
        this.renderedPdfFile = renderedPdfFile;
    }

    public String getPageTitle() {
        return pageTitle;
    }

    public RenderedPdfFile getRenderedPdfFile() {
        return renderedPdfFile;
    }

    public List<PdfNode> getChildren() {
        return children;
    }

    public void addChild(PdfNode child) {
        children.add(child);
    }

    public String getFilename() {
        return renderedPdfFile.getFile().getAbsolutePath();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PdfNode pdfNode = (PdfNode) o;
        return Objects.equals(pageTitle, pdfNode.pageTitle) &&
                Objects.equals(renderedPdfFile, pdfNode.renderedPdfFile) &&
                Objects.equals(children, pdfNode.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageTitle, renderedPdfFile, children);
    }
}
